<%@ include file="../inc_header.jsp"%>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<title>List Patients</title>
<%@ include file="../inc_background.jsp"%>
<style>
#floater {
	position: relative;
	float: left;
	height: 50%;
	margin-bottom: -200px;
	width: 1px;
}

#centered {
	position: relative;
	clear: left;
	height: 400px;
	width: 80%;
	max-width: 500px;
	min-width: 300px;
	margin: 0 auto;
}
</style>
</head>
<body>
	<div id="floater"></div>
	<div id="centered">
		<fieldset id="myfieldset" class="rounded">
			<div align="center">
				<c:if test="${param.updated}">
					<span class="alert">The patient profile was saved successfully.</span><p/>
				</c:if>
				<h1>Patient List</h1>
			</div>
			<table>
				<c:forEach items="${allPatients}" var="patient">
					<tr>
						<td><a href="<c:url value="/profile?uri=${patient.key}" />"><c:out
									value="${patient.value}" /></a></td>
					</tr>
				</c:forEach>
			</table>
		</fieldset>
	</div>
	<div id="bottom">
		<p>
	</div>
</body>
</html>