package gov.va.med.vos.patientProfile.web;

import gov.va.med.vos.patientProfile.data.CalDAVDAO;
import gov.va.med.vos.patientProfile.domain.Profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value = "/profile")
public class ProfileController {

	@Autowired
	private CalDAVDAO calDAVDAO;

	@RequestMapping(method = RequestMethod.GET)
	public String getEditForm(Model model, @RequestParam String uri) {
		Profile p = calDAVDAO.getPatientProfile(uri);
		model.addAttribute(p);
		return "profile/editForm";
	}

	@RequestMapping(method = RequestMethod.POST)
	public String edit(Profile profile, BindingResult result) {
		if (result.hasErrors()) {
			return "profile/editForm";
		}
		
		profile = calDAVDAO.updatePatientProfile(profile);
		return "redirect:/profile?updated=true&uri=" + profile.getUri();
	}

}
