@echo off

@rem save current directory
@set OLDDIR=%CD%

@set MAX_UNDEPLOY_SECS=30
@set MAX_DEPLOY_SECS=60

cd %DEPLOYMENTS_FOLDER%

@rem ------------------------------------------------ undeploy

if not exist %EAR_NAME%.deployed goto :removeDeployment
@rem deleting this will kick off a JBoss undeploy
echo Undeploying existing %EAR_NAME%...
del %EAR_NAME%.deployed

@rem loop for MAX_UNDEPLOY_SECS seconds until app is undeployed. If undeploy
@rem fails, attempt delete of ear dir anyway.
setlocal enableextensions enabledelayedexpansion
set /a "undeploySecs = 0"
:waitForUndeploy
if exist %EAR_NAME%.undeployed GOTO :removeDeployment
if %undeploySecs% GEQ %MAX_UNDEPLOY_SECS% (
	echo Undeploy of %EAR_NAME% failed, attempting to delete and redeploy anyway.
	goto :removeDeployment
)
timeout /t 1 /nobreak > NUL
set /a undeploySecs+=1
echo Waiting %undeploySecs%/%MAX_UNDEPLOY_SECS% secs for %EAR_NAME% to undeploy...
goto :waitForUndeploy
endlocal

echo Cleaning deployment directory...
:removeDeployment
if exist %EAR_NAME%\* RD /S /Q %EAR_NAME%
if exist %EAR_NAME%* del /F /Q %EAR_NAME%*
if exist *.failed del /F /Q *.deployed
if exist *.failed del /F /Q *.failed

@rem ------------------------------------------------ prepare new deployment
:newDeployment
echo Deploying new %EAR_NAME%...
mkdir %EAR_NAME%
cd %EAR_NAME%
jar -xf %MAVEN_EAR_LOC%

@rem ------------------------------------------------ trigger deployment
cd %DEPLOYMENTS_FOLDER%
echo Requesting deployment of %EAR_NAME%...
echo>> %EAR_NAME%.dodeploy

setlocal enableextensions enabledelayedexpansion
set /a "deploySecs = 0"
:waitForDeploy
if exist %EAR_NAME%.deployed (
	echo Deployment into JBoss was successful.
	goto :end
)
if exist %EAR_NAME%.failed (
	echo Deployment failed, see console / logs for details.
	goto :end
)
if %deploySecs% GEQ %MAX_DEPLOY_SECS% (
	echo Deployment time expired, see console / logs for errors or increase the acceptable deployment duration.
	goto :end
)
timeout /t 1 /nobreak > NUL
set /a deploySecs+=1
echo Waiting %deploySecs%/%MAX_DEPLOY_SECS% secs for deployment to complete...
goto :waitForDeploy
endlocal

:end

@rem restore current directory
chdir /D %OLDDIR%