package gov.va.med.vos.common;

import java.io.StringWriter;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Node;

public class XMLUtil {

	static TransformerFactory transformerFactory;

	static {
		try {
			transformerFactory = TransformerFactory.newInstance();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
	}

	public static String printXML(Node firstElement)
			throws TransformerConfigurationException,
			TransformerFactoryConfigurationError, TransformerException {
		return printXML(firstElement, null);
	}

	public static String printXML(Node firstElement, Source xslTransformation)
			throws TransformerConfigurationException,
			TransformerFactoryConfigurationError, TransformerException {
		Transformer transformer = xslTransformation != null ? transformerFactory
				.newTransformer(xslTransformation) : transformerFactory
				.newTransformer();
		transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperty(
				"{http://xml.apache.org/xslt}indent-amount", "2");

		StreamResult result = new StreamResult(new StringWriter());
		DOMSource source = new DOMSource(firstElement);
		transformer.transform(source, result);
		String body = result.getWriter().toString();
		return body;
	}

}
