package gov.va.med.vos.common;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class DetailCapturingResponseHandler implements ResponseHandler<String> {

	int responseStatus = -1;
	String body;

	@Override
	public String handleResponse(HttpResponse response)
			throws HttpResponseException, IOException {
		responseStatus = response.getStatusLine().getStatusCode();
		HttpEntity entity = response.getEntity();
		if (entity != null)
			try {
				body = EntityUtils.toString(entity);
			} catch (Exception ignored) {
			}

		StatusLine statusLine = response.getStatusLine();
		if (statusLine.getStatusCode() >= 300) {
			throw new HttpResponseException(statusLine.getStatusCode(),
					statusLine.getReasonPhrase());
		}

		return body;
	}
}