package gov.va.med.vos.common;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;

public class CustomRedirectStrategy extends DefaultRedirectStrategy {

	static final Set<String> EXTRA_REDIRECTABLE_METHODS = new HashSet<String>();

	static {
		EXTRA_REDIRECTABLE_METHODS.add("PROPFIND");
		EXTRA_REDIRECTABLE_METHODS.add("OPTIONS");
	}

	@Override
	public boolean isRedirected(HttpRequest request, HttpResponse response,
			HttpContext context) throws ProtocolException {
		boolean isRedirect = false;
		try {
			isRedirect = super.isRedirected(request, response, context);
		} catch (ProtocolException e) {
			e.printStackTrace();
		}
		if (!isRedirect) {
			int responseCode = response.getStatusLine().getStatusCode();
			if (responseCode == 301 || responseCode == 302) {
				return true;
			}
		}
		return isRedirect;
	}

	/*
	 * Add support for following redirects for custom CalDAV methods
	 */
	@Override
	public HttpUriRequest getRedirect(HttpRequest request,
			HttpResponse response, HttpContext context)
			throws ProtocolException {
		URI uri = getLocationURI(request, response, context);
		String method = request.getRequestLine().getMethod();

		HttpUriRequest req = null;
		if (HttpHead.METHOD_NAME.equalsIgnoreCase(method)) {
			// log.info("Redirecting to {} as {}", uri.toString(),
			// HttpHead.METHOD_NAME);
			req = new HttpHead(uri);
		} else if (EXTRA_REDIRECTABLE_METHODS.contains(method)) {
			// log.info("Redirecting to {} as {}", uri.toString(), method);
			RequestWrapper wrapper = new RequestWrapper(request);
			wrapper.setURI(uri);
			req = wrapper;
		} else {
			// log.info("Redirecting to {} as {}", uri.toString(),
			// HttpGet.METHOD_NAME);
			req = new HttpGet(uri);
		}
		// log.info("(If this is unexpected, your path may need a trailing slash)");

		return req;
	}
}