package gov.va.med.vos.common;

import java.net.URISyntaxException;
import java.util.Map;

public class Command {

	// ----------------------------------------------- Fields

	private String method;
	private String path;
	private String body;
	private Map<String, String> headers;
	private boolean emulateBrowserUserAgent;

	// ----------------------------------------------- Constructors

	public Command(String method, String path, String body,
			Map<String, String> headers, boolean emulateBrowserUserAgent)
			throws URISyntaxException {
		this.method = method;
		this.path = path;
		this.body = body;
		this.headers = headers;
		this.emulateBrowserUserAgent = emulateBrowserUserAgent;
	}

	// ----------------------------------------------- Business Methods

	public String toString(boolean logBody) {
		StringBuilder sb = new StringBuilder();
		sb.append(method).append(" - ");
		sb.append(path);
		if (body != null && logBody)
			sb.append("\n").append(body);
		return sb.toString();
	}

	// ----------------------------------------------- Common Methods

	public String toString() {
		return toString(false);
	}

	// -------------------------------------------- Accessor Methods

	public boolean isEmulateBrowserUserAgent() {
		return emulateBrowserUserAgent;
	}

	public Map<String, String> getHeaders() {
		return headers;
	}

	public String getPath() {
		return path;
	}

	public String getMethod() {
		return method;
	}

	public String getBody() {
		return body;
	}

}
