<?php

namespace gov\va\med\vos\DAV;

use Sabre\DAV;
use Sabre\DAV\Property;
use Sabre\DAV\IProperties;

/**
 * Decorator pattern for Server that changes the display names for better
 * readability. This is used by the BrowserPlugin.
 *
 * @author Connor Barry
 */
class BrowserServerWrapper {

	protected $server;

	public function __construct(Server $server)
	{
		$this->server = $server;
	}

	public function getPropertiesForPath($path, $propertyNames = array(), $depth = 0) {
		$results = $this->server->getPropertiesForPath($path, $propertyNames, $depth);
		foreach($results as &$result) {
			list(, $name) = DAV\URLUtil::splitPath($result['href']);

			if (!strncmp($name, "PAT_", 4)) {
				$displayVal = !array_key_exists("{DAV:}displayname", $result[200]) ?
				substr($name, 4) : $result[200]["{DAV:}displayname"];
				$result[200]["{DAV:}displayname"] = "Patient " . $displayVal;
			} else if (!strncmp($name, "CLI_", 4)) {
				$displayVal = "";
				$remainder = substr($name, 4);
				$test = explode("_", $remainder);
				if (count($test) == 2) {
					$displayVal .= "Facility " . $test[0] . " > ";
					if (!array_key_exists("{DAV:}displayname", $result[200]) ||
					$result[200]["{DAV:}displayname"] == $name) {
						$displayVal .= "Clinic " . $test[1];
					} else {
						$displayVal .= "Clinic \"" . $result[200]["{DAV:}displayname"] . "\"";
					}
				} else {
					$displayVal .=  "Clinic \"" . $remainder . "\"";
				}
				$result[200]["{DAV:}displayname"] = $displayVal;
			} else if (!strncmp($name, "RM_", 3)) {
				$displayVal = "";
				$remainder = substr($name, 3);
				$test = explode("_", $remainder);
				if (count($test) == 2) {
					$displayVal .= "Facility " . $test[0] . " > ";
					if (!array_key_exists("{DAV:}displayname", $result[200]) ||
							$result[200]["{DAV:}displayname"] == $name) {
						$displayVal .= "Room " . $test[1];
					} else {
						$displayVal .= "Room \"" . $result[200]["{DAV:}displayname"] . "\"";
					}
				} else {
					$displayVal .=  "Room \"" . $remainder . "\"";
				}
				$result[200]["{DAV:}displayname"] = $displayVal;
			} else if (!strncmp($name, "PRO_", 4)) {
				$displayVal = !array_key_exists("{DAV:}displayname", $result[200]) ?
				substr($name, 4) : $result[200]["{DAV:}displayname"];
				$result[200]["{DAV:}displayname"] = "Provider " . $displayVal;
			}
		}
		
		usort($results, array($this, "displayNameComparator"));
		
		return $results;
	}

	function displayNameComparator($a, $b) {
		if ($a == $b)
			return 0;
		
		$val1 = isset($a[200]['{DAV:}displayname']) ? $a[200]['{DAV:}displayname'] : $a['href'];
		$val2 = isset($b[200]['{DAV:}displayname']) ? $b[200]['{DAV:}displayname'] : $b['href'];
		
		return strcasecmp($val1, $val2) < 0 ? -1 : 1;
	}

	public function __call($method, $args)
	{
		return call_user_func_array(array($this->server, $method), $args);
	}

	public function __get($property)
	{
		if (property_exists($this->server, $property)) {
			return $this->server->$property;
		}
		return null;
	}

	public function __set($property, $value)
	{
		$this->server->$property = $value;
		return $this;
	}


}
