<?php

namespace gov\va\med\vos\DAV;

use Sabre\DAV;
use Sabre\DAV\Browser;
use Sabre\DAV\Property\GetLastModified;
use Sabre\DAV\Property\ResourceType;
use Sabre\DAV\Property\SupportedReportSet;
use Sabre\DAV\IProperties;
use Sabre\CardDAV\IDirectory;
use Sabre\DAV\XMLUtil;

/**
 * NodePropertySearch Plugin
 *
 * @author Connor Barry
 */
class BrowserPlugin extends DAV\Browser\Plugin {

	/**
	 * Initializes the plugin and subscribes to events
	 *
	 * @param DAV\Server $server
	 * @return void
	 */
	public function initialize(DAV\Server $server) {
		if (!$server instanceof Server) {
			throw new \Exception("Populated server isn't an instance of the VOS Server!");
		}
		parent::initialize($server);
		$decoratedServer = new BrowserServerWrapper($server);
		$this->server = $decoratedServer;
	}
	
	public function generateDirectoryIndex($path) {
		$parentHtml = parent::generateDirectoryIndex($path);
		
		$html="<hr>";
		$html.="<style>table#attrTable tr:nth-child(even) {background-color: #EEEEEE;}</style>";
		$html.="<table id='attrTable' cellpadding='3'>";
		$myprops = $this->server->getUnfilteredPropertiesForPath($path);
		
		$newprops = array();
		foreach($myprops as $p0=>$p1) {
			$newkey = XMLUtil::parseClarkNotation($p0)[1];
			$newprops[$newkey] = $p1;
		}
		
		uksort($newprops, 'strcasecmp');
		
		foreach ($newprops as $p0=>$p1) {
			if ($p1 instanceof \DateTime) {
				$p1 = $p1->format(\DateTime::ATOM);
			} else if ($p1 instanceof GetLastModified) {
				$p1 = $p1->getTime()->format(\DateTime::ATOM);
			} else if ($p1 instanceof ResourceType) {
				$rt = $p1->getValue();
				if (!is_array($rt)) $rt = array($rt);
				$this->swapResourceTypesWithFriendlyNames($rt);
				$p1 = implode(", ", $rt);
			} else if ($p1 instanceof SupportedReportSet) {
				$reportSets = $p1->getValue();
		
				$p1 = implode("<br />", $reportSets);
			} else {
				$p1 = $this->escapeHTML(print_r($p1, true));
			}
		
			$p0 = $this->escapeHTML($p0);
			$html.="<tr valign='top'><td align='right' nowrap>" . $p0 . ":</td><td>" . $p1 . "</td></tr>";
		}
		$html.="</table><hr>";
		
		/* insert code before footer */
		$pos = strrpos($parentHtml, "<address>", -1);
		$fullHtml = substr($parentHtml, 0, $pos) . $html . substr($parentHtml, $pos);
		
		return $fullHtml;
	}

	private function swapResourceTypesWithFriendlyNames(&$type) {
		foreach($type as $k=>$v) {
			// Some name mapping is preferred
			switch($v) {
				case '{DAV:}collection' :
					$type[$k] = 'Collection';
					break;
				case '{DAV:}principal' :
					$type[$k] = 'Principal';
					break;
				case '{urn:ietf:params:xml:ns:carddav}addressbook' :
					$type[$k] = 'Addressbook';
					break;
				case '{urn:ietf:params:xml:ns:caldav}calendar' :
					$type[$k] = 'Calendar';
					break;
				case '{urn:ietf:params:xml:ns:caldav}schedule-inbox' :
					$type[$k] = 'Schedule Inbox';
					break;
				case '{urn:ietf:params:xml:ns:caldav}schedule-outbox' :
					$type[$k] = 'Schedule Outbox';
					break;
				case '{http://calendarserver.org/ns/}calendar-proxy-read' :
					$type[$k] = 'Proxy-Read';
					break;
				case '{http://calendarserver.org/ns/}calendar-proxy-write' :
					$type[$k] = 'Proxy-Write';
					break;
			}
		}
	}
	
}
