<?php

namespace gov\va\med\vos\DAV;

use Sabre\DAV;
use Sabre\DAV\Property\GetLastModified;
use Sabre\DAV\Property\ResourceType;
use Sabre\DAV\IProperties;
use Sabre\CardDAV\IDirectory;

/**
 * Audit Log Plugin
 *
 * @author Connor Barry
 */
class AuditLogPlugin extends DAV\ServerPlugin {

	protected $logDir;
	
	/**
	 * reference to server class
	 *
	 * @var Sabre\DAV\Server
	 */
	protected $server;

	/**
	 * Creates the object.
	 */
	public function __construct($logDir) {
		$this->logDir = rtrim($logDir, '/');
	}

	/**
	 * Initializes the plugin
	 *
	 * @param DAV\Server $server
	 * @return void
	 */
	public function initialize(DAV\Server $server) {
		$this->server = $server;
		$server->subscribeEvent('beforeMethod',array($this,'logMethod'));
	}

	public function logMethod($methodName, $uri) {
		/* Don't log GET requests */
		if ($methodName == "GET") return true;
		
		$logMsg = $methodName . " -> " . $uri;
		
		$logMsg .= "\nHeaders:";
		$headers = $this->server->httpRequest->getHeaders();
		foreach($headers as $key=>$value) {
			$logMsg .= "\n\t" . $key . ": " . $value;
		}
		
		$logMsg .= "\nBody:";
		$body = $this->server->httpRequest->getBody(true);
		$this->server->httpRequest->setBody($body,true);
		
		$logMsg .= "\n" . $body;
		
		try {
			$this->logFile($logMsg);
		} catch (DAV\Exception $e) {
			try {
				$this->server->createDirectory($this->logDir . "/" . date("Y-m-d"));
			} catch (DAV\Exception $f) {
				$this->server->createDirectory($this->logDir);
				$this->server->createDirectory($this->logDir . "/" . date("Y-m-d"));
			}
			$this->logFile($logMsg);
		}
		return true;
	}
	
	private function logFile($body) {
		$etag = null;
		$this->server->createFile($this->logDir . "/" . date("Y-m-d") . "/" . $this->getTimestamp() . ".txt", $body, $etag);
	}

	function getTimestamp()
	{
		list($usec, $sec) = explode(" ", microtime());
		return date("H_i_s_", $sec) . substr($usec, 2, 8) . date("_a", $sec);
	}
	
}
