<?php

use Sabre\DAV,
	Sabre\DAVACL;

require_once 'vendor/autoload.php';

date_default_timezone_set('US/Mountain');

$baseUri = '/sabredav/connorserver.php/';

/* Database */
$pdo = new \PDO(
		'mysql:host=127.0.0.1;dbname=sabredav',
		'slickapps',
		'kahuna',
		[]);
$pdo->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);

function exception_error_handler($errno, $errstr, $errfile, $errline ) {
    throw new \ErrorException($errstr, 0, $errno, $errfile, $errline);
}
set_error_handler("exception_error_handler");

$authBackend = new \Sabre\DAV\Auth\Backend\PDO($pdo);
$calendarBackend = new \Sabre\CalDAV\Backend\PDO($pdo);
$principalBackend = new \Sabre\DAVACL\PrincipalBackend\PDO($pdo);

$rootDirectory = new DAV\FSExt\Directory('C:/dev/apps/Apache24/htdocs/sabredav/vascheduling');

// Directory structure
$tree = [
	new \Sabre\CalDAV\Principal\Collection($principalBackend),
	new \Sabre\CalDAV\CalendarRootNode($principalBackend, $calendarBackend),
	$rootDirectory,
];

$server = new gov\va\med\vos\DAV\Server($tree);
$server->xmlNamespaces['http://gov.va.med.vos'] = 'V';

if (isset($baseUri))
    $server->setBaseUri($baseUri);

$authPlugin = new \Sabre\DAV\Auth\Plugin($authBackend,'SabreDAV');
$server->addPlugin($authPlugin);

$aclPlugin = new \Sabre\DAVACL\Plugin();
$aclPlugin->adminPrincipals[] = 'principals/admin';
$server->addPlugin($aclPlugin);

$lockBackend = new DAV\Locks\Backend\File('data/locks');
$lockPlugin = new DAV\Locks\Plugin($lockBackend);
$server->addPlugin($lockPlugin);

$auditLogPlugin = new gov\va\med\vos\DAV\AuditLogPlugin('vascheduling/audit_log');
$server->addPlugin($auditLogPlugin);

$browser = new gov\va\med\vos\DAV\BrowserPlugin();
$server->addPlugin($browser);

$caldavPlugin = new \Sabre\CalDAV\Plugin();
$server->addPlugin($caldavPlugin);

$nodePropertySearchPlugin = new gov\va\med\vos\DAV\NodePropertySearchPlugin();
$server->addPlugin($nodePropertySearchPlugin);



$server->exec();
