package gov.va.med.vos.service.util;

import org.jboss.soa.esb.http.HttpRequest;
import org.jboss.soa.esb.message.Message;

/**
 * Low level utility class for manipulating Messages that contain an HTTP
 * request.
 */
public class HttpRequestMessageUtils {

	/**
	 * Extract the HttpRequest from the Message.
	 * 
	 * @param message
	 *            A message containing an HttpRequest.
	 * @return The HttpRequest contained in the Message.
	 */
	public HttpRequest extractHttpRequest(Message message) {
		return HttpRequest.getRequest(message);
	}
}
