package gov.va.med.vos.service.model;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

import net.fortuna.ical4j.model.Parameter;

/**
 * The Location of an Event.
 */
public class Location implements Participant, Serializable {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -2186520441646579695L;
	
	private URI principalUri;
	
	private net.fortuna.ical4j.model.property.Location iCal4jLocation;

	public Location(net.fortuna.ical4j.model.property.Location iCal4jLocation) throws URISyntaxException {
		 String value = iCal4jLocation.getValue();
		 if (value.equals("")){
			 principalUri = null;
		 } else {
			 principalUri = new URI(value);
		 }
		 this.iCal4jLocation = iCal4jLocation;
	}

	public URI getPrincipalUri() {
		return principalUri;
	}
	
	public AttendeeType getType(){
		return AttendeeType.valueOf(iCal4jLocation.getParameter(Parameter.CUTYPE).getValue());
	}
	
	public String getName(){
		return iCal4jLocation.getParameter(Parameter.CN).getValue();
	}
	
}
