package gov.va.med.vos.service.model;

import java.net.URI;

public enum AttendeeType{
	PROVIDER,
	PATIENT,
	SPOKE_CVT_ROOM,
	HUB_CVT_ROOM,
	ROOM,
	HUB_CLINIC,
	LOCATION;
	
	
	public static AttendeeType getTypeByPrincipalURI(URI principalURI){
		AttendeeType type;
		String path = principalURI.getPath();
		if (path.contains("providers")){
			type = AttendeeType.PROVIDER;
		} else if (path.contains("patients")){
			type = AttendeeType.PATIENT;
		} else if (path.contains("Rooms")) {
			type = AttendeeType.ROOM;
		} else {
			throw new IllegalArgumentException("value did not match any enum value");
		}
		
		return type;
	}
}
