package gov.va.med.vos.service.model;

import java.io.Serializable;
import java.net.URI;

import net.fortuna.ical4j.model.Parameter;

/**
 * An Event Attendee, identified by the URI of the Attendees Calendar. An
 * Attendee may optionally store an Object reference to its associated Calendar,
 * and has an optional AttendeeType.
 */
public class Attendee implements Serializable, Participant {

	private static final long serialVersionUID = 9108879766671756987L;
	
	net.fortuna.ical4j.model.property.Attendee iCal4jAttendee;
	
	public Attendee(net.fortuna.ical4j.model.property.Attendee attendee){
		this.iCal4jAttendee = attendee;
	}
	
	public Attendee(){
		this.iCal4jAttendee = new net.fortuna.ical4j.model.property.Attendee();
	}

	public URI getPrincipalUri() {
		// The Principal URI is actually stored in the VEVENT RESOURCE URI, which iCal4J assumes is the calendar URI.
		return this.iCal4jAttendee.getCalAddress();
	}
	
	public void setPrincipalUri(URI calAddress){
		this.iCal4jAttendee.setCalAddress(calAddress);
	}
	
	public AttendeeType getType(){
		return AttendeeType.valueOf(iCal4jAttendee.getParameter(Parameter.CUTYPE).getValue());
	}
	
	public String getName(){
		return iCal4jAttendee.getParameter(Parameter.CN).getValue();
	}

}
