package gov.va.med.vos.service.model;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import net.fortuna.ical4j.model.DateRange;
import net.fortuna.ical4j.model.DateTime;


public class AppointmentRequest implements Serializable {

	private static final long serialVersionUID = -2561241666138650646L;

	//the resources for needed for this appointment
	private List<URI> principalUris;					//Identified resources; just need their calendar
	private List<AttendeeType> requiredResources;		//Unidentified resources; need to find candidates before fetching calendars
	
	private List<AppointmentCategory> categories;
	
	private String summary;
	
	private int length;
	
	private DateRange dateRange;
	
	private Clinic clinic;
	
	private Clinic hubClinic;
	
	public AppointmentRequest() {
		principalUris = new ArrayList<URI>();
		requiredResources = new ArrayList<AttendeeType>();
	}
	
	public Clinic getHubClinic() {
		return hubClinic;
	}

	public void setHubClinic(Clinic hubClinic) {
		this.hubClinic = hubClinic;
	}
	
	public List<URI> getPrincipalUris() {
		return principalUris;
	}

	public List<AttendeeType> getRequiredResources() {
		return requiredResources;
	}
	
	public void setDateRange(DateRange dateRange) {
		this.dateRange = dateRange;
	}

	public int getLength() {
		return length;
	}

	public void setLength(int length) {
		this.length = length;
	}

	public List<AppointmentCategory> getCategories() {
		if (categories == null){
			categories = new ArrayList<AppointmentCategory>();
		}
		return categories;
	}

	public void setCategories(List<AppointmentCategory> categories) {
		this.categories = categories;
	}
	
	/**
	 * @return either FOLLOW-UP or INITIAL
	 */
	public AppointmentCategory getAppointmentVisitType(){
		for (AppointmentCategory cat : categories){
			if (cat == AppointmentCategory.FOLLOWUP || cat == AppointmentCategory.INITIAL){
				return cat;
			}
		}
		return null;
	}
	
	/**
	 * @return either REGULAR or TELEHEALTH
	 */
	public AppointmentCategory getAppointmentType(){
		for (AppointmentCategory cat : categories){
			if (cat == AppointmentCategory.REGULAR || cat == AppointmentCategory.TELEHEALTH){
				return cat;
			}
		}
		return null;
	}
	
	public boolean isTelehealth(){
		if (categories.contains(AppointmentCategory.TELEHEALTH)){
			return true;
		} else {
			return false;
		}
	}

	public DateTime getStartDate() {
		return (DateTime) dateRange.getRangeStart();
	}


	public DateTime getEndDate() {
		return (DateTime) dateRange.getRangeEnd();
	}

	public Clinic getClinic() {
		return clinic;
	}

	public void setClinic(Clinic clinic) {
		this.clinic = clinic;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	@Override
	public String toString() {
		return "AppointmentRequest [summary=" + summary + ", length=" + length
				+ ", getAppointmentVisitType()=" + getAppointmentVisitType()
				+ ", getAppointmentType()=" + getAppointmentType()
				+ ", getStartDate()=" + getStartDate() + ", getEndDate()="
				+ getEndDate() + "]";
	}

	
}
