package gov.va.med.vos.service.model;

public enum AppointmentCategory {
	
	REGULAR("REGULAR", "Regular"),
	INITIAL("INITIAL", "Initial"),
	TELEHEALTH("TELEHEALTH", "Telehealth"),
	FOLLOWUP("FOLLOW-UP", "Follow-up", "FOLLOW-ON"),
	OFFICE_VISIT("OFFICEVISIT", "Office-visit");
	
	private String[] values;
	
	private AppointmentCategory(String ... values){
		this.values = values;
	}
	
	public String getValue(){
		return this.values[0];
	}
	
	public String getUriValue(){
		return values[1];
	}
	
	public String[] getValues(){
		return this.values;
	}
	
	public static AppointmentCategory getAppointmentCategory(String value){
		if (value == null){
			throw new IllegalArgumentException("null value");
		}
		for (AppointmentCategory cat : values()){
			for (String v : cat.getValues()){
				if (value.equalsIgnoreCase(v)){
					return cat;
				}
			}
		}
		throw new IllegalArgumentException("value did not match any enum value");
	}

}
