package gov.va.med.vos.service.actions;

import gov.va.med.vos.service.CalDavResponseFormatter;

import javax.xml.bind.JAXBException;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ResponseFormatterAction extends AbstractActionPipelineProcessor {
	private static Logger logger = LoggerFactory
			.getLogger(ResponseFormatterAction.class);
	private CalDavResponseFormatter calDavResponseFormatter;

	public ResponseFormatterAction(ConfigTree config) throws JAXBException {
		calDavResponseFormatter = new CalDavResponseFormatter();
	}

	public Message process(Message msg) throws ActionProcessingException {

		wrapBodyInResponseXml(msg);

		return msg;
	}

	public void wrapBodyInResponseXml(Message message)
			throws ActionProcessingException {

		// Get the iCalendar payload from the current message.
		Object messageBody = message.getBody().get();
		if (false == messageBody instanceof String) {
			// TODO:
			throw new ActionProcessingException(
					"Cannot format the response because the existing message body is not a String.");
		}
		String payload = (String) messageBody;

		// Format the response
		String response;
		try {
			response = calDavResponseFormatter.formatResponse(payload);
		} catch (JAXBException ex) {
			throw new ActionProcessingException(
					"Could not format the response.", ex);
		}
		logger.debug("Formatted response: " + response);
		
		// Set the response as the Message body.
		message.getBody().add(response);

	}
}
