package gov.va.med.vos.service.actions;

import gov.va.med.vos.service.ConfigException;
import gov.va.med.vos.service.model.Event;
import gov.va.med.vos.service.model.Location;
import gov.va.med.vos.service.util.MessageUtils;
import gov.va.medora.mdws.scheduling.manager.SchedulingManager;
import gov.va.medora.mdws.schedulingsvc.AppointmentTO;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class MdwsServiceCallAction extends AbstractActionPipelineProcessor {
	
	private static Logger logger = LoggerFactory
			.getLogger(MdwsServiceCallAction.class);

	private static String vistaURL;
	
	private static final String USER = "vos12345";
	private static String password = "1qazXSW@";
	private static final String APPOINTMENT_TYPE = "9";
	private static final String SCHEDULING_REQUEST_TYPE = "N";
	
	private MessageUtils messageUtils;

	public MdwsServiceCallAction(ConfigTree config) throws ConfigException {
		this.messageUtils = new MessageUtils();
		
		Properties properties = new Properties();
		
		try {
			properties.load(this.getClass().getClassLoader().getResourceAsStream("/META-INF/vos.properties"));
			
			vistaURL = properties.getProperty("vista_service_url");
		} catch (FileNotFoundException e) {
			throw new ConfigException("Unable to locate vos.properties", e);
		} catch (IOException e) {
			throw new ConfigException("Error reading vos.properties", e);
		}
	}

	public Message process(Message message) throws ActionProcessingException {
		logger.info("Updating patient calendar on clinic VistA");
		
		Event event = messageUtils.extractEvent(message);
		
		String patientIEN = messageUtils.extractPatientIEN(message);
		String clinicIEN = messageUtils.extractClinicIEN(message);
		Location location = messageUtils.extractLocation(message);
		String timezone = messageUtils.extractTimezone(message);
		
		//TODO find a better way to do this
		String site = "501MC";
		if (location.getPrincipalUri().toString().contains("501MC")){
			site = "501MC";
			password = "1qazXSW@";
		} else if (location.getPrincipalUri().toString().contains("601MC")){
			site = "601MC";
			password = "1qazXSW@3edc";
		} else if (location.getPrincipalUri().toString().contains("401MC")){
			site = "401MC";	
			password = "1qazXSW@";
		}
		
		try {
				SchedulingManager schedulingManager = new SchedulingManager(
						vistaURL, site, USER, password, null);
				AppointmentTO scheduledAppt = schedulingManager
						.orchestratedMakePatientAppointment(patientIEN, clinicIEN,
								event.getAppointmentTimestamp(), timezone, APPOINTMENT_TYPE,
								Integer.toString(event.getAppointmentLength()),
								SCHEDULING_REQUEST_TYPE);
				
				logger.info(scheduledAppt.toString());
				
		} catch (Exception e) {
			throw new ActionProcessingException("Failed to make appointment in VistA", e);
		}
		
		return message;
	}

}
