package gov.va.med.vos.service.actions;

import gov.va.med.vos.service.CalDavDAO;
import gov.va.med.vos.service.CalDavException;
import gov.va.med.vos.service.ConfigException;
import gov.va.med.vos.service.model.Attendee;
import gov.va.med.vos.service.model.Location;
import gov.va.med.vos.service.util.MessageUtils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import vos.med.va.gov.PatientVistAIEN;


public class FetchPatientVistaId extends AbstractActionPipelineProcessor {
	
	private static Logger log = LoggerFactory.getLogger(FetchPatientVistaId.class);
	
	private CalDavDAO calDavDAO;
	private MessageUtils messageUtils;
	
	public FetchPatientVistaId(ConfigTree configTree) throws CalDavException, ConfigException{
		calDavDAO = new CalDavDAO();
		messageUtils = new MessageUtils();
	}

	public Message process(Message message) throws ActionProcessingException {
			log.info("Fetching Patient VistA identifier");
			
			Attendee patient = messageUtils.extractPatient(message);
			Location location = messageUtils.extractLocation(message);
			
			
			String[] clinicUriPath = location.getPrincipalUri().getPath().split("/");
			log.info(clinicUriPath.toString());
			
			String facilityAbbr = clinicUriPath[clinicUriPath.length - 2];
			
			String patientUri = patient.getPrincipalUri().toString();
			patientUri += "/MCs/" + facilityAbbr;
			
			List<Object> properties = new ArrayList<Object>();
			properties.add(new PatientVistAIEN());
			Map<String, String> response;
			try {
				response = calDavDAO.getPrincipalProperties(new URI(patientUri), properties);
			} catch (URISyntaxException e) {
				throw new ActionProcessingException("Unable to parse URI", e);
			} catch (CalDavException e) {
				throw new ActionProcessingException("CalDav Error", e);
			}
			
			messageUtils.insertPatientIEN(response.get("PatientVistAIEN"), message);
			
			log.info(response.get("PatientVistAIEN"));
			return message;
	}

}