package gov.va.med.vos.service.actions;

import gov.va.med.vos.service.CalDavDAO;
import gov.va.med.vos.service.CalDavException;
import gov.va.med.vos.service.ConfigException;
import gov.va.med.vos.service.model.Location;
import gov.va.med.vos.service.util.MessageUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import vos.med.va.gov.CalendarTimezone;
import vos.med.va.gov.VistAClinicIEN;

public class FetchClinicVistaIdAction extends AbstractActionPipelineProcessor {
	
	private static Logger log = LoggerFactory.getLogger(FetchClinicVistaIdAction.class);
	
	private CalDavDAO calDavDAO;
	private MessageUtils messageUtils;
	
	public FetchClinicVistaIdAction(ConfigTree configTree) throws CalDavException, ConfigException{
		calDavDAO = new CalDavDAO();
		messageUtils = new MessageUtils();
	}

	public Message process(Message message) throws ActionProcessingException {
		log.info("Fetching Clinic VistA identifier");
		
		Location location = messageUtils.extractLocation(message);
		
		if (location.getName().equals("HOME")){
			return message;
		}
		
		List<Object> properties = new ArrayList<Object>();
		properties.add(new VistAClinicIEN());
		properties.add(new CalendarTimezone());
		
		Map<String, String> response;
		try {
			response = calDavDAO.getPrincipalProperties(location.getPrincipalUri(), properties);
		} catch (CalDavException e) {
			throw new ActionProcessingException("CalDav Error", e);
		}
		
		messageUtils.insertClinicIEN(response.get("VistAClinicIEN"), message);
		messageUtils.insertTimezone(response.get("Calendar-timezone"), message);
		
		return message;
	}

}
