package gov.va.med.vos.service.actions;

import gov.va.med.vos.service.CalDavDAO;
import gov.va.med.vos.service.CalDavException;
import gov.va.med.vos.service.ConfigException;
import gov.va.med.vos.service.model.AppointmentRequest;
import gov.va.med.vos.service.model.Attendee;
import gov.va.med.vos.service.model.AttendeeType;
import gov.va.med.vos.service.model.Calendar;
import gov.va.med.vos.service.model.Clinic;
import gov.va.med.vos.service.model.ResourceOption;
import gov.va.med.vos.service.util.MessageUtils;

import java.util.List;
import java.util.Map;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchAttendeeCalendar extends AbstractActionPipelineProcessor {
	
	private static Logger log = LoggerFactory.getLogger(FetchAttendeeCalendar.class);
	
	private MessageUtils messageUtils;
	private CalDavDAO calDavDAO;
	
	public FetchAttendeeCalendar(ConfigTree tree) throws CalDavException, ConfigException {
		this.messageUtils = new MessageUtils();
		this.calDavDAO = new CalDavDAO();
	}

	public Message process(Message message) throws ActionProcessingException {
		log.info("****** Fetching attendee calendars ******");
		
		AppointmentRequest request = messageUtils.extractAppointmentRequest(message);
		
		Map<AttendeeType, List<ResourceOption>> resourceMap = messageUtils.extractResourceMap(message);
		
		//retrieve calendars
		for (List<ResourceOption> resources : resourceMap.values()){
			
			for (ResourceOption resource : resources){
				try {
					resource.setCalendar(calDavDAO.getFreeBusyTimes(resource, request.getStartDate(), request.getEndDate()));
				} catch (CalDavException e) {
					throw new ActionProcessingException("unable to retrieve calendar from calDAV for principal " + resource, e);
				}
			}
		}
		
		Clinic clinic = request.getClinic();
		
		log.info(clinic.toString());
		
		if (clinic.isHome()){
			clinic.setCalendar(new Calendar());
		} else {
			try {
				clinic.setCalendar(calDavDAO.getFreeBusyTimes(clinic, request.getStartDate(), request.getEndDate()));
			} catch (CalDavException e) {
				throw new ActionProcessingException("unable to retrieve calendar for clinic " + clinic, e);
			}
		}
		
		if (request.isTelehealth()){
			try {
				request.getHubClinic().setCalendar(calDavDAO.getFreeBusyTimes(request.getHubClinic(), request.getStartDate(), request.getEndDate()));
			} catch (CalDavException e) {
				throw new ActionProcessingException("unable to retrieve calendar for clinic " + clinic, e);
			}
			
			messageUtils.putToResourceMap(message, AttendeeType.HUB_CLINIC, request.getHubClinic());
		}
		
		
		messageUtils.putToResourceMap(message, AttendeeType.LOCATION, clinic);
				
		messageUtils.insertAppointmentRequest(request, message);
		
//		messageUtils.mapRequestOntoDefault(messageUtils
//				.extractAppointmentRequest(message),
//				(HashMap<AttendeeType, List<Attendee>>) messageUtils
//						.extractResourceMap(message), message);
		
		return message;
	}
	
	
}
