package gov.va.med.vos.service;

public class TextMatchPropertyFilter {

	private String propertyName;
	private String matchingText;

	public TextMatchPropertyFilter(String propertyName, String matchingText) {
		this.propertyName = propertyName;
		this.matchingText = matchingText;
	}
	
	public String getPropertyName() {
		return propertyName;
	}

	public String getMatchingText() {
		return matchingText;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((matchingText == null) ? 0 : matchingText.hashCode());
		result = prime * result
				+ ((propertyName == null) ? 0 : propertyName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TextMatchPropertyFilter other = (TextMatchPropertyFilter) obj;
		if (matchingText == null) {
			if (other.matchingText != null)
				return false;
		} else if (!matchingText.equals(other.matchingText))
			return false;
		if (propertyName == null) {
			if (other.propertyName != null)
				return false;
		} else if (!propertyName.equals(other.propertyName))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "TextMatchPropertyFilter [propertyName=" + propertyName
				+ ", matchingText=" + matchingText + "]";
	}

}
