package gov.va.med.vos.service;

import gov.va.med.vos.service.model.Calendar;

import java.io.IOException;
import java.io.StringReader;

import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;


/**
 * Parses iCalendar VCALENDARs.
 */
public class CalendarParser {

	private CalendarBuilder calendarBuilder;

	public CalendarParser() {
		this.calendarBuilder = new CalendarBuilder();

	}

	/**
	 * Parse an iCalendar VCALENDAR.
	 * 
	 * @param vCalendar
	 * @return A Calendar.
	 * @throws CalendarParserException 
	 */
	public Calendar parse(String vCalendar) throws CalendarParserException {
		StringReader vCalendarReader = new StringReader(vCalendar);
		net.fortuna.ical4j.model.Calendar iCalendar;
		try {
			iCalendar = calendarBuilder.build(vCalendarReader);
		} catch (IOException e) {
			throw new CalendarParserException("Could not parse Calendar", e);
		} catch (ParserException e) {
			throw new CalendarParserException("Could not parse Calendar", e);
		}
		Calendar calendar = new Calendar(iCalendar);
		return calendar;
	}

}
