package gov.va.med.vos.service;

import ietf.params.xml.ns.caldav.CalendarData;
import dav.Any;
import dav.Multistatus;
import dav.Propstat;
import dav.Response;

import java.io.StringWriter;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

/**
 * Wraps an iCalendar payload in a CalDav XML multistatus response.
 */
public class CalDavResponseFormatter {

	private JAXBContext jaxb;

	public CalDavResponseFormatter() throws JAXBException {
		jaxb = JAXBContext.newInstance(Multistatus.class, CalendarData.class);
	}

	/**
	 * Format a response.
	 * 
	 * @param payload
	 * @return
	 * @throws JAXBException
	 */
	public String formatResponse(String payload) throws JAXBException {

		// Wrap it in a DAV:multistatus response element

		// <D:multistatus xmlns:D="DAV:"
		// xmlns:C="urn:ietf:params:xml:ns:caldav">
		Multistatus multistatus = new Multistatus();

		// <D:response>
		List<Response> responses = multistatus.getResponse();
		Response response = new Response();
		responses.add(response);

		// TODO: Do not hardcode this.
		// <D:href>
		response.setFirstHref("http://localhost:8080/scheduling-service/http/appointments");
		// </D:href>

		// <D:propstat>
		List<Propstat> propstats = response.getPropstat();
		Propstat propstat = new Propstat();
		propstats.add(propstat);

		// <D:prop>
		Any prop = new Any();
		propstat.setProp(prop);
		List<Object> propContent = prop.getContent();

		// <C:calendar-data>
		// iCalendar payload
		CalendarData calendarData = new CalendarData();
		calendarData.getContent().add(payload);
		propContent.add(calendarData);
		// </C:calendar-data>

		// </D:prop>

		// <D:status>
		propstat.setStatus("HTTP/1.1 200 OK");
		// </D:status>

		// </D:propstat>
		// </D:response>
		// </D:multistatus>

		// Marshall the response
		String responseString;
		Marshaller marshaller = jaxb.createMarshaller();
		StringWriter newMessageBodyWriter = new StringWriter();
		marshaller.marshal(multistatus, newMessageBodyWriter);
		responseString = newMessageBodyWriter.toString();

		return responseString;
	}
}
