package gov.va.med.vos.engine.batch;

import gov.va.med.vos.common.AuthSettings;
import gov.va.med.vos.common.CalDAVManager;
import gov.va.med.vos.common.ProxySettings;

import java.net.URISyntaxException;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.w3c.dom.Element;

public class RequestContext {

	static final String ATTR_DEFAULT_EMULATE_BROWSER_USER_AGENT = "defaultEmulateBrowserUserAgent";
	static final String ATTR_DEFAULT_LOG_HEADERS = "defaultLogHeaders";
	static final String ATTR_DEFAULT_LOG_BODY = "defaultLogBody";

	static final String ATTR_BASE_URI = "baseURI";

	static final String ATTR_HTTP_BASIC_AUTH_USERNAME = "httpBasicAuthUsername";
	static final String ATTR_HTTP_BASIC_AUTH_PASSWORD = "httpBasicAuthPassword";

	static final String ATTR_PROXY_SERVER = "proxyServer";
	static final String ATTR_PROXY_PORT = "proxyPort";
	static final String ATTR_PROXY_TYPE = "proxyType";
	static final String ATTR_PROXY_AUTH_USERNAME = "proxyAuthUsername";
	static final String ATTR_PROXY_AUTH_PASSWORD = "proxyAuthPassword";

	Boolean defaultEmulateBrowserUserAgent = null;
	Boolean defaultLogHeaders = null;
	Boolean defaultLogBody = null;

	String baseURIStr;

	String httpAuthUsername;
	String httpAuthPassword;

	String proxyServer;
	String proxyPort;
	String proxyType;
	String proxyAuthUsername;
	String proxyAuthPassword;

	public RequestContext(Element root) throws URISyntaxException {
		baseURIStr = root.getAttribute(ATTR_BASE_URI);
		if (root.hasAttribute(ATTR_DEFAULT_EMULATE_BROWSER_USER_AGENT))
			defaultEmulateBrowserUserAgent = Boolean.valueOf(root
					.getAttribute(ATTR_DEFAULT_EMULATE_BROWSER_USER_AGENT));
		if (root.hasAttribute(ATTR_DEFAULT_LOG_HEADERS))
			defaultLogHeaders = Boolean.valueOf(root
					.getAttribute(ATTR_DEFAULT_LOG_HEADERS));
		if (root.hasAttribute(ATTR_DEFAULT_LOG_BODY))
			defaultLogBody = Boolean.valueOf(root
					.getAttribute(ATTR_DEFAULT_LOG_BODY));

		httpAuthUsername = root.getAttribute(ATTR_HTTP_BASIC_AUTH_USERNAME);
		httpAuthPassword = root.getAttribute(ATTR_HTTP_BASIC_AUTH_PASSWORD);

		proxyServer = root.getAttribute(ATTR_PROXY_SERVER);
		proxyPort = root.getAttribute(ATTR_PROXY_PORT);
		proxyType = root.getAttribute(ATTR_PROXY_TYPE);
		proxyAuthUsername = root.getAttribute(ATTR_PROXY_AUTH_USERNAME);
		proxyAuthPassword = root.getAttribute(ATTR_PROXY_AUTH_PASSWORD);
	}

	public CalDAVManager createManager() throws URISyntaxException {
		AuthSettings authSettings = null;
		if (StringUtils.isNotBlank(httpAuthUsername))
			authSettings = new AuthSettings(httpAuthUsername, httpAuthPassword);

		ProxySettings proxySettings = null;
		if (StringUtils.isNotBlank(proxyServer)) {
			if (StringUtils.isNotBlank(proxyAuthUsername)) {
				proxySettings = new ProxySettings(proxyServer,
						Integer.parseInt(proxyPort), proxyType,
						proxyAuthUsername, proxyAuthPassword);
			} else {
				proxySettings = new ProxySettings(proxyServer,
						Integer.parseInt(proxyPort), proxyType);
			}
		}

		return new CalDAVManager(baseURIStr, authSettings, proxySettings);
	}

	public void applyRequestSpecificModifications(HttpRequest request) {
		// ...
	}

}