package gov.va.med.vos.engine.batch;

import gov.va.med.vos.common.Command;
import gov.va.med.vos.common.XMLUtil;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.transform.stream.StreamSource;

import org.apache.commons.lang3.BooleanUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Request {

	static final int DEFAULT_HTTP_PORT = 80;

	/* Command element level attributes */
	static final String ATTR_PATH = "path";
	static final String ATTR_FAIL_ON_ERROR = "failOnError";
	static final String ATTR_EMULATE_BROWSER_USER_AGENT = "emulateBrowserUserAgent";
	static final String ATTR_LOG_HEADERS = "logHeaders";
	static final String ATTR_LOG_BODY = "logBody";

	public static Request buildRequest(RequestContext context, Element node,
			Element overrideBodyNode) throws Exception {
		String method = node.getLocalName();

		String path = null;
		boolean failOnError = true;
		Boolean emulateBrowserUserAgent = null;
		Boolean logHeaders = null;
		Boolean logBody = null;

		NamedNodeMap attributes = node.getAttributes();
		Map<String, String> extraHeaders = new HashMap<String, String>();
		for (int i = 0; i < attributes.getLength(); i++) {
			Node attributeNode = attributes.item(i);
			String name = attributeNode.getNodeName();
			String value = attributeNode.getNodeValue();
			if (ATTR_FAIL_ON_ERROR.equals(name)) {
				failOnError = Boolean.valueOf(value);
			} else if (ATTR_EMULATE_BROWSER_USER_AGENT.equals(name)) {
				emulateBrowserUserAgent = Boolean.valueOf(value);
			} else if (ATTR_LOG_HEADERS.equals(name)) {
				logHeaders = Boolean.valueOf(value);
			} else if (ATTR_LOG_BODY.equals(name)) {
				logBody = Boolean.valueOf(value);
			} else if (ATTR_PATH.equals(name)) {
				if (!value.startsWith("/"))
					value = "/" + value;
				path = value;
			} else {
				if (!"bodyTemplateId".equals(name))
					extraHeaders.put(name, value);
			}
		}

		if (emulateBrowserUserAgent == null)
			emulateBrowserUserAgent = BooleanUtils
					.toBoolean(context.defaultEmulateBrowserUserAgent);
		if (logHeaders == null)
			logHeaders = BooleanUtils.toBoolean(context.defaultLogHeaders);
		if (logBody == null)
			logBody = BooleanUtils.toBoolean(context.defaultLogBody);

		Node firstText = null;
		Node firstElement = null;
		NodeList allChildren = overrideBodyNode != null ? overrideBodyNode
				.getChildNodes() : node.getChildNodes();

		for (int i = 0; i < allChildren.getLength(); i++) {
			Node child = allChildren.item(i);
			if (child.getNodeType() == Node.TEXT_NODE && firstText == null)
				firstText = child;
			if (child.getNodeType() == Node.ELEMENT_NODE) {
				if (firstElement != null)
					throw new Exception(
							"The command has more than one child (but must only contain one, which"
									+ " represents the HTTP body).");
				firstElement = child;
			}
		}

		String body = null;
		if (firstElement != null) {
			InputStream in = Request.class.getClassLoader()
					.getResourceAsStream("stripNamespaces.xsl");
			body = XMLUtil.printXML(firstElement, new StreamSource(in));
			/* hacky hack */
			body = body.replace("\"urn:DAV\"", "\"DAV:\"");
		} else if (firstText != null) {
			body = firstText.getTextContent().trim();
		}

		return new Request(method, path, body, extraHeaders, failOnError,
				emulateBrowserUserAgent, logHeaders, logBody);
	}

	private boolean failOnError;
	private boolean logHeaders;
	private boolean logBody;

	private Command command;

	private Request(String method, String path, String body,
			Map<String, String> headers, boolean failOnError,
			boolean emulateBrowserUserAgent, boolean logHeaders, boolean logBody)
			throws URISyntaxException {
		this.command = new Command(method, path, body, headers,
				emulateBrowserUserAgent);
		this.failOnError = failOnError;
		this.logHeaders = logHeaders;
		this.logBody = logBody;
	}

	// ----------------------------------------------- Common Methods

	public String toString() {
		return command.toString(logBody);
	}

	// -------------------------------------------- Accessor Methods

	public boolean isLogHeaders() {
		return logHeaders;
	}

	public boolean isLogBody() {
		return logBody;
	}

	public boolean isFailOnError() {
		return failOnError;
	}

	public Command getCommand() {
		return command;
	}

}
