package gov.va.med.vos.engine.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PositionalXMLReader {
	final static String LINE_NUMBER_KEY_NAME = "lineNumber";

	public static Document readXML(final InputStream is) throws IOException,
			SAXException {
		final Document doc;
		SAXParser parser;
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			factory.setValidating(true);
			factory.setNamespaceAware(true);
			parser = factory.newSAXParser();

			DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory
					.newInstance();
			docBuilderFactory.setValidating(true);
			docBuilderFactory.setNamespaceAware(true);

			DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
			builder.setErrorHandler(getErrorHandler());

			doc = builder.newDocument();
		} catch (ParserConfigurationException e) {
			throw new RuntimeException(
					"Can't create SAX parser / DOM builder.", e);
		}

		final Stack<Element> elementStack = new Stack<Element>();
		final StringBuilder textBuffer = new StringBuilder();
		DefaultHandler handler = new DefaultHandler() {

			private Locator locator;

			@Override
			public void setDocumentLocator(final Locator locator) {
				/*
				 * Save the locator, so that it can be used later for line
				 * tracking when traversing nodes.
				 */
				this.locator = locator;
			}

			@Override
			public void startElement(final String uri, final String localName,
					final String qName, final Attributes attributes)
					throws SAXException {
				addTextIfNeeded();
				final Element el = doc.createElementNS(uri, qName);

				for (int i = 0; i < attributes.getLength(); i++) {
					// el.setAttribute(attributes.getQName(i),
					// attributes.getValue(i));
					el.setAttributeNS(attributes.getURI(i),
							attributes.getQName(i), attributes.getValue(i));
				}

				el.setUserData(LINE_NUMBER_KEY_NAME,
						String.valueOf(this.locator.getLineNumber()), null);
				elementStack.push(el);
			}

			@Override
			public void endElement(final String uri, final String localName,
					final String qName) {
				addTextIfNeeded();
				final Element closedEl = elementStack.pop();
				if (elementStack.isEmpty()) { // Is this the root element?
					doc.appendChild(closedEl);
				} else {
					final Element parentEl = elementStack.peek();
					parentEl.appendChild(closedEl);
				}
			}

			@Override
			public void characters(final char ch[], final int start,
					final int length) throws SAXException {
				textBuffer.append(ch, start, length);
			}

			// Outputs text accumulated under the current node
			private void addTextIfNeeded() {
				if (textBuffer.length() > 0) {
					final Element el = elementStack.peek();
					final Node textNode = doc.createTextNode(textBuffer
							.toString());
					el.appendChild(textNode);
					textBuffer.delete(0, textBuffer.length());
				}
			}

		};
		parser.parse(is, handler);

		return doc;
	}

	static ErrorHandler getErrorHandler() {
		return new ErrorHandler() {
			public void fatalError(SAXParseException exception)
					throws SAXException {
				System.err.println("fatalError: " + exception);
			}

			public void error(SAXParseException exception) throws SAXException {
				System.err.println("error: " + exception);
			}

			public void warning(SAXParseException exception)
					throws SAXException {
				System.err.println("warning: " + exception);
			}
		};
	}
}
