

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;


public class TestTimezone {
	private final static SimpleDateFormat VISTA_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss");

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Date date = new Date();
		System.out.println(date.toString());
		System.out.println(formatForVISTA(date, "America/New_York"));
		System.out.println(formatForVISTA(date, "America/Chicago"));
		System.out.println(formatForVISTA(date, "America/Denver"));
		System.out.println(formatForVISTA(date, "America/Los_Angeles"));
		System.out.println(formatForVISTA(date, "America/Anchorage"));
		System.out.println(formatForVISTA(date, "America/Adak"));
	}

	private static String formatForVISTA(Date theDate, String timezone)
	{
		VISTA_FORMAT.setTimeZone(TimeZone.getTimeZone(timezone));	
		return VISTA_FORMAT.format(theDate.getTime());
	}
}
