package gov.va.medora.mdws.scheduling.exception;

/**
 * The Class MDWSSchedulingException. Wrapper exception class
 * that handles errors returned from MDWS Scheduling Service.
 * <p>
 *  <A HREF="http://www.hp.com"> Hewlett-Packard Enterprise Services - OSEHRA/VA Scheduling Contest</A> 
 * </p>
 * @author <a href="mailto:david.aar.lucas@hp.com">Aaron Lucas</a>
 */
public class MDWSSchedulingException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4058333648002656790L;

	/**
	 * The Constructor.
	 */
	public MDWSSchedulingException()
	{
		super();
	}


	/**
	 * The Constructor.
	 *
	 * @param message the message
	 */
	public MDWSSchedulingException(String message)
	{
		super(message);
	}
	

	/**
	 * The Constructor.
	 *
	 * @param cause the cause
	 */
	public MDWSSchedulingException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * The Constructor.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public MDWSSchedulingException(String message, Throwable cause)
	{
		super(message,cause);
	}

}
