package gov.va.med.scheduling.xml;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import gov.va.med.scheduling.dto.Provider;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class ProviderXmlProcessor{
	/**
	 * 
	 */
	private XPathFactory xPathFactory = null;	
	/**
	 * 
	 */
	private DocumentBuilderFactory docBuilderFactory =null;
	/**
	 * 
	 */
	private DocumentBuilder documentBuilder = null;
	/**
	 * 
	 */
	private ProviderXmlProcessor(){
		try{
			xPathFactory = XPathFactory.newInstance();		
			docBuilderFactory= DocumentBuilderFactory.newInstance();
			documentBuilder = docBuilderFactory.newDocumentBuilder();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	/**
	 * 
	 */
	private static ProviderXmlProcessor INSTANCE = new ProviderXmlProcessor();
	/**
	 * 
	 * @return
	 */
	public static ProviderXmlProcessor getInstance(){
		return INSTANCE;
	}
	/**
	 * 
	 */
	public List<String> processXmlForProviderIds(String xml){
		List<String> providerIdList = new ArrayList<String>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {				
				final Node responseNode = responseList.item(i);				
				String href = xPath.evaluate("href", responseNode);	
				String[] hrefArray = href.split("/");
				providerIdList.add(hrefArray[6]);
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return providerIdList;
	}
	/**
	 * 
	 */
	public Provider processXmlForProvider(String idProvider, String xml){	
		Provider provider = new Provider();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);						
			final Node responseNode = responseList.item(0);							
			final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
			final Node propStatNode = propStatList.item(0);	
			String status = xPath.evaluate("status", propStatNode);
			System.out.println("status::"+status);
			if(status.equals("HTTP/1.1 200 OK")){
				final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
				final Node propNode = propList.item(0);							
				String displayName 			= xPath.evaluate("displayname", propNode);
				String jobTitle 			= xPath.evaluate("JobTitle", propNode);	
				provider.setName(displayName);	
				provider.setId(idProvider);	
				provider.setSpecialty(jobTitle);
			}							
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return provider;
	}
}
