package gov.va.med.scheduling.xml;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.component.VEvent;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Patient;
import gov.va.med.scheduling.infra.GlobalFunctions;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class PatientXmlProcessor extends BaseXmlProcessor{	
	/**
	 * 
	 */
	private XPathFactory xPathFactory = null;	
	/**
	 * 
	 */
	private DocumentBuilderFactory docBuilderFactory =null;
	/**
	 * 
	 */
	private DocumentBuilder documentBuilder = null;
	/**
	 * 
	 */
	private PatientXmlProcessor(){
		try{
			xPathFactory = XPathFactory.newInstance();		
			docBuilderFactory= DocumentBuilderFactory.newInstance();
			documentBuilder = docBuilderFactory.newDocumentBuilder();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	/**
	 * 
	 */
	private static PatientXmlProcessor INSTANCE = new PatientXmlProcessor();
	/**
	 * 
	 * @return
	 */
	public static PatientXmlProcessor getInstance(){
		return INSTANCE;
	}
	/**
	 * 
	 */
	public List<Patient> processXml(String xml, String idPatient){
		List<Patient> patientList = new ArrayList<Patient>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {
				Patient patient = new Patient();
				final Node responseNode = responseList.item(i);				
				String href = xPath.evaluate("href", responseNode);			
				if(href.equals("/server.php/vascheduling/principals/users/patients/"+idPatient+"/")){
					final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
					final Node propStatNode = propStatList.item(0);	
					String status = xPath.evaluate("status", propStatNode);
					System.out.println("status::"+status);
					if(status.equals("HTTP/1.1 200 OK")){
						final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
						final Node propNode = propList.item(0);							
						String displayName 			= xPath.evaluate("displayname", propNode);				
						String calendarReference 	= xPath.evaluate("calendarReference", propNode);
						String id 					= xPath.evaluate("ID", propNode);
						String isVeteran 			= xPath.evaluate("IsVeteran", propNode);
						String firstName 			= xPath.evaluate("FirstName", propNode);
						String lastName 			= xPath.evaluate("LastName", propNode);
						String dob					= xPath.evaluate("DOB", propNode);
						String gender				= xPath.evaluate("Gender", propNode);
						String ssn					= xPath.evaluate("SSN", propNode);
						String preferredMCRef		= xPath.evaluate("PreferredMC", propNode);
						
						String idFacility = "501MC";
						Facility facility = null;
						String[] preferredMCRefArray = preferredMCRef.split("/");						
						if(preferredMCRefArray!=null && preferredMCRefArray.length>=8){
							idFacility = preferredMCRefArray[7];	
							System.out.println("Got Patient Facility from CalDAV Server::"+idFacility);
						}
						facility = new Facility();
						facility.setId(idFacility);						
						patient.setFacility(facility);
						
						patient.setName(displayName);	
						patient.setId(id);
						patient.setVeteran(Boolean.valueOf(isVeteran));
						patient.setFirstName(firstName);
						patient.setLastName(lastName);
						patient.setDateOfBirth(GlobalFunctions.stringToDate(dob));
						patient.setSsn(ssn);
						patient.setGender(gender);		
						patient.setCalendarReference(calendarReference);
						patientList.add(patient);
					}													
				}				
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return patientList;
	}		
	/**
	 * 
	 */
	public List<Facility> processXmlForFacilities(String xml){
		List<Facility> facilityList = new ArrayList<Facility>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {				
				final Node responseNode = responseList.item(i);				
				//String href = xPath.evaluate("href", responseNode);							
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);
				System.out.println("status::"+status);
				if(status.equals("HTTP/1.1 200 OK")){
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String displayName 			= xPath.evaluate("displayname", propNode);									
					String facilityReference	= xPath.evaluate("MCReference", propNode);					
					Facility facility = new Facility();
					String[] facilityReferenceArray = facilityReference.split("/");						
					if(facilityReferenceArray!=null && facilityReferenceArray.length>=8){
						facility.setName(displayName);
						facility.setId(facilityReferenceArray[7]);							
					}																	
					facilityList.add(facility);
				}																			
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return facilityList;
	}
	/**
	 * 
	 */
	public List<Appointment> processXmlForCalendar(String xml, Patient patient){
		List<Appointment> appointmentList = new ArrayList<Appointment>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {	
				//if(i==5) break;
				final Node responseNode = responseList.item(i);				
				//String href = xPath.evaluate("href", responseNode);						
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);				
				if(status.equals("HTTP/1.1 200 OK")){
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String calendarData 		= xPath.evaluate("calendar-data", propNode);											
					StringReader sin = new StringReader(calendarData);
					CalendarBuilder builder = new CalendarBuilder();					
					Calendar calendar = builder.build(sin);						
					ComponentList componentList = calendar.getComponents();
					for(int index = 0; index<componentList.size();index++){
						Appointment appointment = new Appointment();
						appointment.setPatient(patient);								
						Component component = (Component)componentList.get(index);						
						if(!(component instanceof VEvent)){
							continue;
						}						
						VEvent vEvent = (VEvent) component;												
						appointment.setIcsFile(vEvent.toString());																																		
						appointment.setId(vEvent.getUid().getValue());
						appointment.setStatus("Scheduled");						
						appointment.setReasonText(vEvent.getSummary().getValue());		
						processLocation(vEvent,appointment);
						processCategories(vEvent,appointment);
						processDateTimes(vEvent,appointment,appointment.getClinic());
						processAttendees(vEvent,appointment);																					
						appointmentList.add(appointment);
					}										
				}																			
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return appointmentList;
	}		
	/**
	 * 
	 */
	public List<String> processXmlForPatientIds(String xml){
		List<String> patientList = new ArrayList<String>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {				
				final Node responseNode = responseList.item(i);				
				String href = xPath.evaluate("href", responseNode);						
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);				
				if(status.equals("HTTP/1.1 200 OK")){					
					String[] hrefArray = href.split("/");						
					if(hrefArray!=null && hrefArray.length>=8){
						String idPatient = hrefArray[6];	
						System.out.println("Got Patient from CalDAV Server::"+idPatient);
						patientList.add(idPatient);
					}										
					
				}													
			}				
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return patientList;
	}		
}
