package gov.va.med.scheduling.xml;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Patient;
import gov.va.med.scheduling.dto.Provider;
import gov.va.med.scheduling.dto.VisitType;
import gov.va.med.scheduling.infra.GlobalFunctions;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class ClinicXmlProcessor extends BaseXmlProcessor{
	/**
	 * 
	 */
	private XPathFactory xPathFactory = null;	
	/**
	 * 
	 */
	private DocumentBuilderFactory docBuilderFactory =null;
	/**
	 * 
	 */
	private DocumentBuilder documentBuilder = null;
	/**
	 * 
	 */
	private ClinicXmlProcessor(){
		try{
			xPathFactory = XPathFactory.newInstance();		
			docBuilderFactory= DocumentBuilderFactory.newInstance();
			documentBuilder = docBuilderFactory.newDocumentBuilder();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	/**
	 * 
	 */
	private static ClinicXmlProcessor INSTANCE = new ClinicXmlProcessor();
	/**
	 * 
	 * @return
	 */
	public static ClinicXmlProcessor getInstance(){
		return INSTANCE;
	}
	/**
	 * 
	 */
	public List<Clinic> processXmlTeleHealthClinics(String xml){
		List<Clinic> clinicList = new ArrayList<Clinic>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {
				Clinic clinic = new Clinic();
				final Node responseNode = responseList.item(i);				
				String href = xPath.evaluate("href", responseNode);	
				System.out.println("href::"+href);
				String[] hrefArray = href.split("/");
				String idClinic = hrefArray[6];
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);
				System.out.println("status::"+status);
				if(status.equals("HTTP/1.1 200 OK")){
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String displayName 			= xPath.evaluate("displayname", propNode);												
					clinic.setName(displayName);	
					clinic.setId(idClinic);					
					clinicList.add(clinic);																	
				}				
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return clinicList;
	}
	/**
	 * 
	 */
	public List<Clinic> processXmlGetClinicsByFacility(Facility facility, String xml){
		List<Clinic> clinicList = new ArrayList<Clinic>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {
				Clinic clinic = new Clinic();
				final Node responseNode = responseList.item(i);				
				String href = xPath.evaluate("href", responseNode);					
				String[] hrefArray = href.split("/");				
				System.out.println("href::"+href+"        "+hrefArray.length);		
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);
				System.out.println("status::"+status);
				if(status.equals("HTTP/1.1 200 OK") && hrefArray.length==7){
					String idClinic = hrefArray[6];
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String displayName 	= xPath.evaluate("displayname", propNode);
					String timezone 	= xPath.evaluate("Calendar-timezone", propNode);	
					clinic.setName(displayName);	
					clinic.setId(idClinic);	
					clinic.setTimezone(GlobalFunctions.getConvertedTimeZone(timezone));
					clinic.setFacility(facility);
					clinicList.add(clinic);																	
				}				
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return clinicList;
	}
	/**
	 * 
	 */
	public List<VisitType> processXmlForVisitTypes(String xml){
		List<VisitType> visitTypeList = new ArrayList<VisitType>();	
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {
				VisitType visitType = new VisitType();
				final Node responseNode = responseList.item(i);				
				String href = xPath.evaluate("href", responseNode);	
				System.out.println("href::"+href);				
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);
				System.out.println("status::"+status);
				if(status.equals("HTTP/1.1 200 OK")){
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String displayName 			= xPath.evaluate("displayname", propNode);
					String duration 			= xPath.evaluate("AppointmentLength", propNode);
					String teleHealthEnabled 	= xPath.evaluate("IsTelehealthSupported", propNode);
					visitType.setDuration(Integer.parseInt(duration));
					visitType.setName(displayName);	
					visitType.setId(href);
					visitType.setTeleHealthSupported(Boolean.valueOf(teleHealthEnabled));
					visitTypeList.add(visitType);																	
				}				
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return visitTypeList;
	}	
	/**
	 * 
	 * @param vEvent
	 * @param appointment
	 */
	protected void processAttendees(VEvent vEvent, Appointment appointment){
		//start attendee Processing
		PropertyList attendeeList = vEvent.getProperties("ATTENDEE");
		for(int j = 0; j<attendeeList.size();j++){
			Property attendeeProperty = (Property)attendeeList.get(j);
			if(attendeeProperty!=null){																															
				String CN = attendeeProperty.getParameter("CN").getValue();//CN="ZZTEST, ONE"
				String CUTYPE = attendeeProperty.getParameter("CUTYPE").getValue();//CUTYPE=PROVIDER;																					
				if("PATIENT".equals(CUTYPE)){
					Patient patient = new Patient();												
					String value = attendeeProperty.getValue();//http://172.31.106.7:80/server.php/vascheduling/principals/users/patients/990002														
					String[] valueArray = value.split(":");
					if(valueArray!=null && valueArray.length>=3){
						String patientUrl = valueArray[2];//443/server.php/vascheduling/principals/users/patients/990002										
						String[] patientUrlArray = patientUrl.split("/");
						if(patientUrl!=null && patientUrlArray.length>=7){
							String idPatient = patientUrlArray[6];//990002											
							patient.setId(idPatient);
							patient.setName(CN);
							appointment.setPatient(patient);
						}
					}
				}
				else if("PROVIDER".equals(CUTYPE)){																							
					Provider provider = new Provider();												
					String value = attendeeProperty.getValue();//http://172.31.106.7:80/server.php/vascheduling/principals/users/providers/990029									
					String[] valueArray = value.split(":");
					if(valueArray!=null && valueArray.length>=3){
						String providerUrl = valueArray[2];//443/server.php/vascheduling/principals/users/providers/990029										
						String[] providerUrlArray = providerUrl.split("/");
						if(providerUrlArray!=null && providerUrlArray.length>=7){
							String idProvider = providerUrlArray[6];//990029											
							provider.setId(idProvider);
							provider.setName(CN);
							appointment.setProvider(provider);
						}
					}
				}
			}																																					
		}//end Attendee Processing							
	}		
	/**
	 * 
	 */
	public List<Appointment> processXmlForCalendar(String xml,Clinic clinic){
		List<Appointment> appointmentList = new ArrayList<Appointment>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {	
				//if(i==5) break;
				final Node responseNode = responseList.item(i);				
				//String href = xPath.evaluate("href", responseNode);						
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);				
				if(status.equals("HTTP/1.1 200 OK")){
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String calendarData 		= xPath.evaluate("calendar-data", propNode);											
					StringReader sin = new StringReader(calendarData);
					CalendarBuilder builder = new CalendarBuilder();					
					Calendar calendar = builder.build(sin);						
					ComponentList componentList = calendar.getComponents();
					for(int index = 0; index<componentList.size();index++){
						Appointment appointment = new Appointment();											
						Component component = (Component)componentList.get(index);						
						if(!(component instanceof VEvent)){
							continue;
						}						
						VEvent vEvent = (VEvent) component;												
						appointment.setIcsFile(vEvent.toString());																																		
						appointment.setId(vEvent.getUid().getValue());
						appointment.setStatus("Scheduled");						
						appointment.setReasonText(vEvent.getSummary().getValue());		
						
						processCategories(vEvent,appointment);
						processDateTimes(vEvent,appointment,null);
						appointment.setStartDateTimeClinic(
							GlobalFunctions.convertAsPerTimezoneClinic(
								vEvent.getStartDate().getDate()
							, 	clinic.getTimezone()
							)							
						);						
						appointment.setEndDateTimeClinic(
							GlobalFunctions.convertAsPerTimezoneClinic(
								vEvent.getEndDate().getDate()
							, 	clinic.getTimezone()
							)
						);
						System.out.println("ERROR>>>>> clinicxml 303" + appointment.toString());
						processAttendees(vEvent,appointment);	
						System.out.println("ERROR>>>>> clinicxml 305" + appointment.toString());
						processLocation(vEvent,appointment);
						System.out.println("ERROR>>>>> clinicxml 307" + appointment.toString());
						appointmentList.add(appointment);
					}										
					System.out.println("ERROR>>>>> clinicxml 310" + appointmentList.toString());
				}																			
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return appointmentList;
	}	
	
}
