package gov.va.med.scheduling.xml;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Location;
import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.AppointmentCategory;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Provider;
import gov.va.med.scheduling.dto.VisitType;
import gov.va.med.scheduling.infra.GlobalConstants;
import gov.va.med.scheduling.infra.GlobalFunctions;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class BaseXmlProcessor{		
	/**
	 * 
	 */
	public BaseXmlProcessor(){		
	}
	/**
	 * 
	 */
	private static BaseXmlProcessor INSTANCE = new BaseXmlProcessor();
	/**
	 * 
	 * @return
	 */
	public static BaseXmlProcessor getInstance(){
		return INSTANCE;
	}	
	
	/**
	 * 
	 * @param vEvent
	 * @param appointment
	 */
	protected void processCategories(VEvent vEvent, Appointment appointment){
		AppointmentCategory appointmentCategory = null;
		VisitType visitType = new VisitType();	
		visitType.setTeleHealthSupported(false);
		Property categoriesProperty = vEvent.getProperty("CATEGORIES");				
		if(categoriesProperty!=null){
			String categories = vEvent.getProperty("CATEGORIES").getValue();			
			if(categories!=null){
				String[] categoriesArray = categories.split(",");
				if(categoriesArray!=null && categoriesArray.length>1){
					String firstCategory = categoriesArray[0];
					String secondCategory = categoriesArray[1];					
					if(!GlobalFunctions.isNullOrEmpty(firstCategory)){						
						if(GlobalConstants.TELEHEALTH.equalsIgnoreCase(firstCategory)){
							appointmentCategory = GlobalFunctions.getCategory(GlobalConstants.TELEHEALTH);						
							visitType.setTeleHealthSupported(true);
						}						
						if(GlobalConstants.OFFICE_VISIT.equalsIgnoreCase(firstCategory) || GlobalConstants.REGULAR.equalsIgnoreCase(firstCategory)){							
							appointmentCategory = GlobalFunctions.getCategory(GlobalConstants.REGULAR);
						}						
						if(GlobalConstants.INITIAL.equalsIgnoreCase(firstCategory) || GlobalConstants.FOLLOW_UP.equalsIgnoreCase(firstCategory)){						
							visitType.setName(firstCategory);		
						}					
					}
					if(!GlobalFunctions.isNullOrEmpty(secondCategory)){	
						if(GlobalConstants.TELEHEALTH.equalsIgnoreCase(secondCategory)){
							appointmentCategory = GlobalFunctions.getCategory(GlobalConstants.TELEHEALTH);						
							visitType.setTeleHealthSupported(true);
						}
						if(GlobalConstants.OFFICE_VISIT.equalsIgnoreCase(secondCategory) || GlobalConstants.REGULAR.equalsIgnoreCase(secondCategory)){					
							appointmentCategory = GlobalFunctions.getCategory(GlobalConstants.REGULAR);
						}						
						if(GlobalConstants.INITIAL.equalsIgnoreCase(secondCategory) || GlobalConstants.FOLLOW_UP.equalsIgnoreCase(secondCategory)){						
							visitType.setName(secondCategory);		
						}
					}	
					if(appointmentCategory==null){
						appointmentCategory = GlobalFunctions.getCategory(GlobalConstants.REGULAR);		
					}					
				}
				if(categoriesArray!=null && categoriesArray.length==1){
					appointmentCategory = GlobalFunctions.getCategory(categoriesArray[0]);
				}
				appointment.setVisitType(visitType);
				appointment.setCategory(appointmentCategory);
			}
		}										
	}	
	/**
	 * 
	 * @param vEvent
	 * @param appointment
	 */
	protected void processDateTimes(VEvent vEvent, Appointment appointment, Clinic location){			
		//System.out.println("location::"+location);
		if(location!=null){
			appointment.setStartDateTimeStr(
				GlobalFunctions.convertAsPerTimezone(
					vEvent.getStartDate().getDate()
				, 	location.getTimezone()
				)							
			);						
			appointment.setEndDateTimeStr(
				GlobalFunctions.convertAsPerTimezone(
					vEvent.getEndDate().getDate()
				, 	location.getTimezone()
				)
			);				
		}		
		appointment.setStartDateTime(vEvent.getStartDate().getDate());
		appointment.setEndDateTime(vEvent.getEndDate().getDate());
	}	
	/**
	 * 
	 * @param vEvent
	 * @param appointment
	 */
	protected void processAttendees(VEvent vEvent, Appointment appointment){
		//start attendee Processing
		PropertyList attendeeList = vEvent.getProperties("ATTENDEE");
		for(int j = 0; j<attendeeList.size();j++){
			Property attendeeProperty = (Property)attendeeList.get(j);
			if(attendeeProperty!=null){																															
				String CN = attendeeProperty.getParameter("CN").getValue();//CN="ZZTEST, ONE"
				String CUTYPE = attendeeProperty.getParameter("CUTYPE").getValue();//CUTYPE=PROVIDER;																	
				if("PATIENT".equals(CUTYPE)){
					continue;
				}
				else if("PROVIDER".equals(CUTYPE)){																							
					Provider provider = new Provider();												
					String value = attendeeProperty.getValue();//http://172.31.106.7:80/server.php/vascheduling/principals/users/providers/990029									
					String[] valueArray = value.split(":");
					if(valueArray!=null && valueArray.length>=3){
						String providerUrl = valueArray[2];//443/server.php/vascheduling/principals/users/providers/990029										
						String[] providerUrlArray = providerUrl.split("/");
						if(providerUrlArray!=null && providerUrlArray.length>=7){
							String idProvider = providerUrlArray[6];//990029											
							provider.setId(idProvider);
							provider.setName(CN);
							appointment.setProvider(provider);
						}
					}
				}
			}																																					
		}//end Attendee Processing							
	}	
	/**
	 * 
	 * @param vEvent
	 * @param appointment
	 */
	protected void processLocation(VEvent vEvent, Appointment appointment){
		//start location processing
		Location locationProperty = vEvent.getLocation();//LOCATION;CN=Medical Center Primary Care;CUTYPE=CLINIC;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/resources/501MC/GAPC1
		if(locationProperty!=null){
			String location = locationProperty.getValue();//http://172.31.106.7:80/server.php/vascheduling/principals/resources/501MC/GAPC1																																								
			String CN = locationProperty.getParameter("CN").getValue();//CN="ZZTEST, ONE"																									
			if(!GlobalFunctions.isNullOrEmpty(CN) && !GlobalConstants.HOME.equalsIgnoreCase(CN)){					
				String[] locationValueArray = location.split("/");
				if(locationValueArray!=null && locationValueArray.length>=9){
					String idFacility = locationValueArray[7];
					Facility facility = GlobalFunctions.getFacility(idFacility);
					String idClinic = locationValueArray[8];									
					Clinic clinic = new Clinic();//GAPC1
					clinic.setName(CN);		
					clinic.setId(idClinic);				
					clinic.setTimezone(GlobalFunctions.getClinicTimeZone(idFacility));					
					clinic.setFacility(facility);
					appointment.setFacility(facility);												
					appointment.setClinic(clinic);
				}	
			}
			else if(!GlobalFunctions.isNullOrEmpty(CN) && GlobalConstants.HOME.equalsIgnoreCase(CN)){		
				appointment.setIdSpokeClinic(CN);
			}//end location processing					
		}
	}	
}
