package gov.va.med.scheduling.xml;

import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.infra.GlobalConstants;
import gov.va.med.scheduling.infra.GlobalFunctions;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.component.VEvent;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class AppointmentXmlProcessor extends BaseXmlProcessor{	
	/**
	 * 
	 */
	private XPathFactory xPathFactory = null;	
	/**
	 * 
	 */
	private DocumentBuilderFactory docBuilderFactory =null;
	/**
	 * 
	 */
	private DocumentBuilder documentBuilder = null;
	/**
	 * 
	 */
	private AppointmentXmlProcessor(){
		try{
			xPathFactory = XPathFactory.newInstance();		
			docBuilderFactory= DocumentBuilderFactory.newInstance();
			documentBuilder = docBuilderFactory.newDocumentBuilder();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	/**
	 * 
	 */
	private static AppointmentXmlProcessor INSTANCE = new AppointmentXmlProcessor();
	/**
	 * 
	 * @return
	 */
	public static AppointmentXmlProcessor getInstance(){
		return INSTANCE;
	}
	/**
	 * 
	 */
	public List<Appointment> processXmlForCalendar(String xml, Appointment queryAppointment){
		List<Appointment> appointmentList = new ArrayList<Appointment>();
		try {
			XPath xPath = xPathFactory.newXPath();				
			final InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));		
			final Document document = documentBuilder.parse(inputSource);
			final NodeList responseList =
					(NodeList) xPath.evaluate("multistatus/response", document, XPathConstants.NODESET);
			for (int i = 0; i < responseList.getLength(); i++) {	
				//if(i==5) break;
				final Node responseNode = responseList.item(i);				
				//String href = xPath.evaluate("href", responseNode);						
				final NodeList propStatList = (NodeList) xPath.evaluate("propstat", responseNode,XPathConstants.NODESET);
				final Node propStatNode = propStatList.item(0);	
				String status = xPath.evaluate("status", propStatNode);				
				if(status.equals("HTTP/1.1 200 OK")){
					final NodeList propList = (NodeList) xPath.evaluate("prop", propStatNode, XPathConstants.NODESET);
					final Node propNode = propList.item(0);							
					String calendarData 		= xPath.evaluate("calendar-data", propNode);											
					StringReader sin = new StringReader(calendarData);
					CalendarBuilder builder = new CalendarBuilder();					
					Calendar calendar = builder.build(sin);						
					ComponentList componentList = calendar.getComponents();
					for(int index = 0; index<componentList.size();index++){
						Appointment appointment = new Appointment();
						appointment.setPatient(queryAppointment.getPatient());								
						Component component = (Component)componentList.get(index);												
						if(!(component instanceof VEvent)){
							continue;
						}						
						VEvent vEvent = (VEvent) component;												
						appointment.setIcsFile(vEvent.toString());																																		
						appointment.setId(vEvent.getUid().getValue());
						appointment.setStatus("Scheduled");						
						appointment.setReasonText(vEvent.getSummary().getValue());								
						processLocation(vEvent,appointment);
						processCategories(vEvent,appointment);
						if(!GlobalFunctions.isNullOrEmpty(queryAppointment.getIdSpokeClinic())
								&& !GlobalConstants.HOME.equalsIgnoreCase(queryAppointment.getIdSpokeClinic())
						){
							Clinic clinic = new Clinic();
							clinic.setId(queryAppointment.getIdSpokeClinic());
							clinic.setTimezone(GlobalFunctions.getClinicTimeZone(queryAppointment.getIdSpokeFacility()));
							processDateTimes(vEvent,appointment,clinic);
						}
						else if(!GlobalFunctions.isNullOrEmpty(queryAppointment.getIdSpokeClinic())
								&& GlobalConstants.HOME.equalsIgnoreCase(queryAppointment.getIdSpokeClinic())
						){							
							processDateTimes(vEvent,appointment,null);
						}
						else{
							processDateTimes(vEvent,appointment,queryAppointment.getClinic());
						}						
						processAttendees(vEvent,appointment);																					
						appointmentList.add(appointment);
					}										
				}																			
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}		
		return appointmentList;
	}	
}
