package gov.va.med.scheduling.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Provider;
import gov.va.med.scheduling.dto.Response;
import gov.va.med.scheduling.infra.GlobalConstants;
import gov.va.med.scheduling.infra.GlobalFunctions;
import gov.va.med.scheduling.infra.JSONDataRepository;
import gov.va.med.scheduling.infra.VAProperties;
import gov.va.med.scheduling.xml.ProviderXmlProcessor;
import gov.va.med.vos.common.AuthSettings;
import gov.va.med.vos.common.CalDAVManager;
import gov.va.med.vos.common.Command;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class ProviderService {	
	/**
	 *
	 */
	public ProviderService(){}
	/**
	 * 
	 * @return
	 */
	public Response getAllProviders(){			
		List<Provider> providerList = new ArrayList<Provider>(JSONDataRepository.getInstance().getProviders().values());
		List<Object> responseList = new ArrayList<Object>();
		Response response = new Response();
		responseList.add(providerList);
		response.setResponseList(responseList);
		return response;
	}
	/**
	 * 
	 * @return
	 */
	public Response getProviders(Facility facility, Clinic clinic){			
		List<Provider> providerList = new ArrayList<Provider>();
		List<String> providerIdList = getProviderIdsFromCalDavServer(facility.getId(),clinic.getId());
		for(String idProvider:providerIdList){
			providerList.add(getProviderFromCalDavServer(idProvider));
		}
		List<Object> responseList = new ArrayList<Object>();
		Response response = new Response();
		responseList.add(providerList);
		response.setResponseList(responseList);
		return response;
	}
	
	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private Provider getProviderFromCalDavServer(String idProvider){		
		System.out.println("PROVIDERID::"+idProvider);
		try{			
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();	
			System.out.println("Request::"+GlobalConstants.GET_PROVIDER);
			Command command = new Command(
								"PROPFIND"
							,	"/vascheduling/principals/users/providers/"+idProvider
							, 	GlobalConstants.GET_PROVIDER
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				return ProviderXmlProcessor.getInstance().processXmlForProvider(idProvider, responseXml);				
			}					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}	
	
	
	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<String> getProviderIdsFromCalDavServer(String idFacility, String idClinic){		
		try{			
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();	
			Map<String, String> inputParams = new HashMap<String, String>();
			inputParams.put(
				"PARAM1"
			,	"http://172.31.106.7:80/server.php/vascheduling/principals/resources/"+idFacility+"/"+idClinic);
			//headers.put("Depth", "1");
			System.out.println("Request::"+GlobalFunctions.getFormattedText(GlobalConstants.GET_PROVIDER_IDS_BY_CLINIC, inputParams));
			Command command = new Command(
								"REPORT"
							,	"/vascheduling/principals/users/providers"
							, 	GlobalFunctions.getFormattedText(GlobalConstants.GET_PROVIDER_IDS_BY_CLINIC, inputParams)
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				List<String> providerIdList = ProviderXmlProcessor.getInstance().processXmlForProviderIds(responseXml);
				if(providerIdList!=null && providerIdList.size()>0){
					return providerIdList;
				}	
			}					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}	
	/**
	 * 
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String args[]){		
		Facility facility = new Facility();
		facility.setId("501MC");
		
		Clinic clinic = new Clinic();
		clinic.setId("GAPC1");
		ProviderService service = new ProviderService();
		Response response = service.getProviders(facility,clinic);
		List<Object> responseList = response.getResponseList();
		List<Provider> providerList = (List<Provider>)responseList.get(0);
		for(Provider provider :providerList){
			System.out.println(provider.getId());
			System.out.println(provider.getName());
			System.out.println(provider.getSpecialty());	
		}		
	}
}

