package gov.va.med.scheduling.service;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.scheduling.dto.Address;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Scheduler;
import gov.va.med.scheduling.dto.Response;
import gov.va.med.scheduling.dto.User;
import static gov.va.med.scheduling.infra.GlobalFunctions.*;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class ProfileService {	
	/**
	 *
	 */
	public ProfileService()
	{
	}
	/**
	 * 
	 * @param idScheduler
	 * @return
	 */
	public Response getSchedulerProfile(User user){						
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(getScheduler(user));
		response.setResponseList(responseList);
		return response;
	}	
	
	/**
	 * 
	 * @param idScheduler
	 * @return
	 */
	private Scheduler getScheduler(User user){
		Scheduler scheduler = new Scheduler();
		scheduler.setId(user.getIdUser());
		scheduler.setFirstName("John");
		scheduler.setMiddleName("P");
		scheduler.setLastName("Scheduler");
		scheduler.setDateOfBirth(stringToDate("12/01/1980"));
		
		Address address = new Address();
		address.setAddressLine1("1234 Frying Pan Road");
		address.setCity("Herndon");
		address.setState("VA");
		address.setZipcode("20170");
		address.setCountry("US");
		scheduler.setAddress(address);
		
		Clinic clinic = new Clinic();
		clinic.setId("GAPC1");
		clinic.setName("Medical Center Primary Care");
		clinic.setTimezone("America/New_York");
		clinic.setTeleHealthSupported(true);
		
		Facility defaultFacility = new Facility();
		defaultFacility.setId("501MC");
		defaultFacility.setName("Georgia VA Medical Center");
		clinic.setFacility(defaultFacility);
		
		scheduler.setDefaultClinic(clinic);
		scheduler.setDefaultFacility(defaultFacility);
		
		return scheduler;
	}		
	/**
	 * 
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String args[]){				
		User user = MVIStubService.getInstance().getUser("one");
		ProfileService service = new ProfileService();	
		Response response = service.getSchedulerProfile(user);
		List<Object> responseList = response.getResponseList();
		Scheduler scheduler = (Scheduler)responseList.get(0);		
		System.out.println("Default Facility Id::"+scheduler.getDefaultFacility().getId());
		System.out.println("Default Facility Name::"+scheduler.getDefaultFacility().getName());
		
		
		System.out.println("Default Clinic Id::"+scheduler.getDefaultClinic().getId());
		System.out.println("Default Clinic Name::"+scheduler.getDefaultClinic().getName());
		
		/*for(Appointment eachAppointment:appointmentList){
			System.out.println("Appointment ID::"+eachAppointment.getId());
			System.out.println("Appointment Start::"+eachAppointment.getStartDateTime());
			System.out.println("Appointment Ends::"+eachAppointment.getEndDateTime());
			//System.out.println("Clinic Name::"+eachAppointment.getClinic().getName());
			//System.out.println("Clinic Id::"+eachAppointment.getClinic().getId());
			//System.out.println("Provider Name::"+eachAppointment.getProvider().getName());
			//System.out.println("Provider Id::"+eachAppointment.getProvider().getId());
		}				*/
	}
}

