package gov.va.med.scheduling.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.scheduling.dto.Address;
import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.Employer;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.InsuranceInfo;
import gov.va.med.scheduling.dto.InsuranceProvider;
import gov.va.med.scheduling.dto.Patient;
import gov.va.med.scheduling.dto.PatientPreferences;
import gov.va.med.scheduling.dto.Phone;
import gov.va.med.scheduling.dto.Response;
import gov.va.med.scheduling.dto.User;
import gov.va.med.scheduling.infra.GlobalConstants;
import gov.va.med.scheduling.infra.GlobalFunctions;
import gov.va.med.scheduling.infra.VAProperties;
import gov.va.med.scheduling.xml.PatientXmlProcessor;
import gov.va.med.vos.common.AuthSettings;
import gov.va.med.vos.common.CalDAVManager;
import gov.va.med.vos.common.Command;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class PatientService {		
	/**
	 * 
	 */
	/*private static final String DUMMY_RESPONSE = 
			"<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
	+"<multistatus xmlns=\"DAV:\">"
	 +" <response>"
	  +"  <href>/server.php/calendars/PAT_990000/default/9263504FD3AD.ics</href>"
	  + " <propstat>"
	   + "  <prop>"
	    + "   <calendar-data xmlns=\"urn:ietf:params:xml:ns:caldav\">BEGIN:VCALENDAR\n"
	+"VERSION:2.0\n"
	+"BEGIN:VEVENT\n"
	+"UID:9263504FD3AD\n"
	+"SEQUENCE:0\n"
	+"DTSTAMP:20130402T185300Z\n"
	+"DTSTART:20130602T160000Z\n"
	+"DTEND:20130602T170000Z\n"
	+"CATEGORIES:FOLLOW-ON,TELEHEALTH,\n"
	+"TRANSP:OPAQUE\n"
	+"SUMMARY:Reason for the visit\n"
	+"ORGANIZER;CN=\"Admin\":http://172.31.106.7:80/server.php/principals/admin\n"
	+"ATTENDEE;CN=\"ZZTEST, ONE\";CUTYPE=PATIENT;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/users/patients/990000\n"
	+"ATTENDEE;CN=\"SMITH, JANE\";CUTYPE=PROVIDER;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/users/providers/990029\n"
	+"LOCATION;CN=\"Medical Center Primary Care\";CUTYPE=CLINIC;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/resources/501MC/GAPC1\n"
	+"ROOM;CN=\"Room 110\":http://172.31.106.7:80/server.php/vascheduling/principals/resources/501MC/Rooms/GACVT1\n"
	+"END:VEVENT\n"
	+"END:VCALENDAR</calendar-data>\n"
	        +"<getetag>\"7e8bf81fcd3a6d45667067d5710929a4\"</getetag>\n"
	     + "</prop>\n"
	     + "<status>HTTP/1.1 200 OK</status>\n"
	    +"</propstat>\n"
	 + "</response>\n"
	+"</multistatus>\n"
	        ;*/
			
			
	
	
	/**
	 *
	 */
	public PatientService()
	{
	}
	/**
	 * 
	 * @return
	 */
	public Response getPatientDetails(User user){		
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();						
		responseList.add(getPatient(user));
		response.setResponseList(responseList);
		return response;
	}		
	/**
	 * 
	 * @return
	 */
	public Response getPatientDetails(Patient patientFromUi){		
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();						
		responseList.add(getPatient(patientFromUi));
		response.setResponseList(responseList);
		return response;
	}
	/**
	 * 
	 * @param idPatient
	 * @return
	 */
	private Patient getPatient(Patient patientFromUi) {
		Patient patient = getPatientFromCalDavServer(patientFromUi.getId());			
		List<Facility> facilityList = getFacilitiesFromCalDavServer(patient);
		for(Facility facility:facilityList){
			if(facility.getId().equals(patient.getFacility().getId())){
				patient.setFacility(facility);
				break;
			}
		}		
		Address address = new Address();
		address.setAddressLine1("1234 Frying Pan Road");
		address.setCity("Herndon");
		address.setState("VA");
		address.setZipcode("20170");
		address.setCountry("US");
		if(patient!=null){
			patient.setAddress(address);			
			Phone phone = new Phone();
			phone.setType("M");
			phone.setNumber("703-123-4567");			
			List<Phone> phoneList = new ArrayList<Phone>();
			phoneList.add(phone);
			patient.setPhoneList(phoneList);
			patient.setInsuranceInfo(getInsuranceInfo());		
			patient.setPreferences(getPatientPreferences());
		}	
		return patient;
	}	
	/**
	 * 
	 * @param idPatient
	 * @return
	 */
	public Response getAppointmentsByPatient(User user, Patient patient){	
		List<Appointment> appointmentList = getAppointmentsForPatient(user,patient);//new ArrayList<Appointment>();					
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(appointmentList);
		response.setResponseList(responseList);
		return response;
	}
	/**
	 * 
	 * @param idPatient
	 * @return
	 */
	public Response getFacilities(User user, Patient patient){	
		List<Facility> facilityList = getFacilitiesFromCalDavServer(patient);				
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(facilityList);
		response.setResponseList(responseList);
		return response;
	}	
	/**
	 * 
	 * @param facility
	 * @return
	 */
	public Response getPatients(Facility facility){	
		List<String> patientIdList = getPatientIdsFromCalDavServer(facility);				
		Response response = new Response();
		List<Patient> patientList = new ArrayList<Patient>();
		for(String idPatient:patientIdList){
			patientList.add(getPatientFromCalDavServer(idPatient));
		}
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(patientList);
		response.setResponseList(responseList);
		return response;
	}
	
	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<String> getPatientIdsFromCalDavServer(Facility facility){		
		try{
			System.out.println("Get Patients from Calendar Server for Facility::"+facility.getId());
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();		
			headers.put("Depth", "3");
			
			Map<String, String> params = new HashMap<String, String>();
			params.put("facility", facility.getId());
			String request = GlobalFunctions.getFormattedText(GlobalConstants.GET_PATIENTS_FOR_FACILITY, params);
			System.out.println("Request " + request);
			Command command = new Command(
								"REPORT"
							,	"/vascheduling/principals/users/patients/"
							, 	request
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				return PatientXmlProcessor.getInstance().processXmlForPatientIds(responseXml);				
			}
					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	
	
	/**
	 * 
	 * @param idPatient
	 * @return
	 */
	private Patient getPatient(User user) {
		Patient patient = getPatientFromCalDavServer(MVIStubService.getInstance().getCalendarId(user.getIdUser()));			
		List<Facility> facilityList = getFacilitiesFromCalDavServer(patient);
		for(Facility facility:facilityList){
			if(facility.getId().equals(patient.getFacility().getId())){
				patient.setFacility(facility);
				break;
			}
		}		
		Address address = new Address();
		address.setAddressLine1("1234 Frying Pan Road");
		address.setCity("Herndon");
		address.setState("VA");
		address.setZipcode("20170");
		address.setCountry("US");
		if(patient!=null){
			patient.setAddress(address);			
			Phone phone = new Phone();
			phone.setType("M");
			phone.setNumber("703-123-4567");			
			List<Phone> phoneList = new ArrayList<Phone>();
			phoneList.add(phone);
			patient.setPhoneList(phoneList);
			patient.setInsuranceInfo(getInsuranceInfo());		
			patient.setPreferences(getPatientPreferences());
		}	
		return patient;
	}	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private Patient getPatientFromCalDavServer(String patientCalendarId){		
		try{
			System.out.println("Get the Patient from Calendar Server::"+patientCalendarId);
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();		
			headers.put("Depth", "0");
			Command command = new Command(
								"PROPFIND"
							,	"/vascheduling/principals/users/patients/"+patientCalendarId
							, 	GlobalConstants.GET_PATIENT_XML
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				List<Patient> patientList = PatientXmlProcessor.getInstance().processXml(responseXml, patientCalendarId);
				if(patientList!=null && patientList.size()>0){
					return patientList.get(0);
				}	
			}
					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<Facility> getFacilitiesFromCalDavServer(Patient patient){		
		try{
			System.out.println("getFacilitiesFromCalDavServer::"+patient.getId());
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();							
			System.out.println("Request::"+GlobalConstants.GET_FACILITIES_FOR_PATIENT);
			System.out.println("/calendars/PAT_"+patient.getId()+"/default");
			Command command = new Command(
								"PROPFIND"
							,	"/vascheduling/principals/users/patients/"+patient.getId()+"/MCs"
							, 	GlobalConstants.GET_FACILITIES_FOR_PATIENT
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				return PatientXmlProcessor.getInstance().processXmlForFacilities(responseXml);				
			}
					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<Appointment> getAppointmentsForPatient(User user, Patient patient){		
		try{
			System.out.println("Get appointment for Patient::"+patient.getId());
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();	
			Map<String, String> params = new HashMap<String, String>();
			
			Date startDate = GlobalFunctions.getTodayWithoutTime();
			Date endDate = GlobalFunctions.addDaysToDate(startDate, 365);
							
			params.put("STARTDATETIME", GlobalFunctions.formatDateForICalendar(startDate));
			params.put("ENDDATETIME", GlobalFunctions.formatDateForICalendar(endDate));
			
			String requestXml = GlobalFunctions.getFormattedText(GlobalConstants.GET_CALENDAR, params);					
			System.out.println("Request::"+requestXml);					
			Command command = new Command(
								"REPORT"
							,	"/calendars/PAT_"+patient.getId()+"/default"
							, 	requestXml
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				return PatientXmlProcessor.getInstance().processXmlForCalendar(responseXml,patient);				
			}
					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @return
	 *//*
	private Appointment getAppointment1(Patient patient){
		Appointment appointment = new Appointment();		
		appointment.setId("1");
		appointment.setPatient(patient);
		appointment.setReasonText("Stomach Ache");
		appointment.setStatus("Scheduled");
		appointment.setStartDateTime(
			stringToDateTime(
				formatDate(new Date()) + " 10:00 AM"
			)
		);
		appointment.setEndDateTime(
			stringToDateTime(
				formatDate(new Date()) + " 11:00 AM"
			)
		);
		appointment.setProvider(getProvider1());
		appointment.setClinic(getClinic1());
		appointment.setCategory(getAppointmentCategory1());
		appointment.setVisitType(getVisitType1());
		return appointment;
	}*/
	/**
	 * 
	 * @return
	 *//*
	private Appointment getAppointment2(Patient patient){
		Appointment appointment = new Appointment();		
		appointment.setId("2");
		appointment.setPatient(patient);
		appointment.setReasonText("PTSD");
		appointment.setStatus("Scheduled");
		appointment.setStartDateTime(
			stringToDateTime(
				formatDate(addDaysToCurrentDate(2)) + " 02:00 PM"
			)
		);
		appointment.setEndDateTime(
			stringToDateTime(
				formatDate(addDaysToCurrentDate(2)) + " 02:30 PM"
			)
		);
		appointment.setProvider(getProvider2());
		appointment.setClinic(getClinic2());
		appointment.setCategory(getAppointmentCategory2());
		appointment.setVisitType(getVisitType2());
		return appointment;
	}	*/
	/**
	 * 
	 * @return
	 *//*
	private VisitType getVisitType1(){
		VisitType reason = new VisitType();
		reason.setId("101");
		reason.setName("Follow-up");			
		reason.setDuration(30);
		return reason;
	}
	*//**
	 * 
	 * @return
	 *//*
	private VisitType getVisitType2(){
		VisitType reason = new VisitType();
		reason.setId("101");
		reason.setName("Initial");			
		reason.setDuration(45);
		return reason;
	}
	*//**
	 * 
	 * @return
	 *//*
	private AppointmentCategory getAppointmentCategory1(){
		AppointmentCategory category = new AppointmentCategory();
		category.setId("101");
		category.setName("Category1 Name");
		category.setDescription("Category1 Description");
		category.setPictureLink("images/appointmentcategory/101.jpg");
		return category;
	}
	*//**
	 * 
	 * @return
	 *//*
	private AppointmentCategory getAppointmentCategory2(){
		AppointmentCategory category = new AppointmentCategory();
		category.setId("102");
		category.setName("Category2 Name");
		category.setDescription("Category2 Description");
		category.setPictureLink("images/appointmentcategory/102.jpg");
		return category;
	}	
	*//**
	 * 
	 * @return
	 *//*
	private Provider getProvider1(){
		Provider provider = new Provider();
		provider.setId("1001");
		provider.setFirstName("Provider1 First Name");
		provider.setLastName("Provider1 Last Name");
		return provider;
	}
	*//**
	 * 
	 * @return
	 *//*
	private Provider getProvider2(){
		Provider provider = new Provider();
		provider.setId("1002");
		provider.setFirstName("Provider2 First Name");
		provider.setLastName("Provider2 Last Name");
		return provider;
	}
	
	*//**
	 * 
	 * @return
	 *//*
	private Clinic getClinic1(){
		Clinic clinic = new Clinic();
		clinic.setId("1001");
		clinic.setName("Clinic1");
		clinic.setSpecialty("General Medicinie");
		return clinic;
	}	
	*//**
	 * 
	 * @return
	 *//*
	private Clinic getClinic2(){
		Clinic clinic = new Clinic();
		clinic.setId("1002");
		clinic.setName("Clinic2");
		clinic.setSpecialty("Mental Health");
		return clinic;
	}*/		
	private PatientPreferences getPatientPreferences(){
		PatientPreferences preferences = new PatientPreferences();
		preferences.setTeleMedicine(true);
		preferences.setTransport(false);
		preferences.setAlertMethod("Text Message");
		preferences.setNotificationMethod("Text Message");
		return preferences;
	}	
	/**
	 * 
	 * @return
	 */
	private InsuranceInfo getInsuranceInfo(){
		InsuranceInfo insuranceInfo = new InsuranceInfo();
		insuranceInfo.setProvider(getInsuranceProvider());		
		insuranceInfo.setEmployer(getEmployer());
		insuranceInfo.setMemberId("1234567890");
		insuranceInfo.setGroupId("S12345");
		return insuranceInfo;
	}	
	/**
	 * 
	 * @return
	 */
	private Employer getEmployer(){
		Employer employer = new Employer();
		employer.setName("HP");
		
		Address address = new Address();
		address.setAddressLine1("1234 McLearn Road");
		address.setCity("Herndon");
		address.setState("VA");
		address.setZipcode("20171");
		address.setCountry("US");
		employer.setAddress(address);
		
		List<Phone> phoneList = new ArrayList<Phone>();
		
		Phone phone = new Phone();
		phone.setType("O");
		phone.setNumber("123-456-7890");
		
		Phone fax = new Phone();
		fax.setType("F");
		fax.setNumber("123-456-7891");
		
		phoneList.add(phone);
		phoneList.add(fax);
		
		employer.setPhoneList(phoneList);
		
		return employer;
	}
	/**
	 * 
	 * @return
	 */
	private InsuranceProvider getInsuranceProvider(){
		
		InsuranceProvider provider = new InsuranceProvider();
		
		provider.setId("1");
		provider.setName("United Health Care");
		
		Address providerAddress = new Address();
		providerAddress.setAddressLine1("P O Box 12345");
		providerAddress.setCity("Atlanta");
		providerAddress.setState("GA");
		providerAddress.setZipcode("34534");
		providerAddress.setCountry("US");		
		provider.setAddress(providerAddress);
		
		List<Phone> providerPhoneList = new ArrayList<Phone>();
		
		Phone providerPhone = new Phone();
		providerPhone.setType("O");
		providerPhone.setNumber("345-123-4567");
		
		Phone providerFax = new Phone();
		providerFax.setType("F");
		providerFax.setNumber("345-123-4568");
		
		providerPhoneList.add(providerPhone);
		providerPhoneList.add(providerFax);
		
		provider.setPhoneList(providerPhoneList);
		
		return provider;
	}		
	/**
	 * 
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String args[]){
		PatientService service = new PatientService();		
		User user = MVIStubService.getInstance().getUser("one");
		Patient patient = new Patient();
		patient.setId("990000");		
		Response response1 = service.getAppointmentsByPatient(user,patient);
		List<Object> responseList = response1.getResponseList();
		//patient = (Patient)responseList.get(0);
		//System.out.println("Facility Id 123::"+patient.getFacility().getId());
		//System.out.println("Facility Name 123::"+patient.getFacility().getName());
		List<Appointment> appointmentList = (List<Appointment>)responseList.get(0);	
		for(Appointment eachAppointment:appointmentList){
			//System.out.println("Appointment Summary::"+eachAppointment.getReasonText());
			//System.out.println("Appointment Category::"+eachAppointment.getCategory().getName());		
			System.out.println("Appointment Visit Type Name::"+eachAppointment.getVisitType().getName());
			System.out.println("Appointment Visit Type Desc::"+eachAppointment.getVisitType().getDescription());
			//System.out.println("Telehealth Supported::"+eachAppointment.getVisitType().isTeleHealthSupported());
			//System.out.println("Appointment Ends::"+eachAppointment.getEndDateTime());
			/*System.out.println("Clinic Name::"+eachAppointment.getClinic().getName());
			System.out.println("Clinic Id::"+eachAppointment.getClinic().getId());
			System.out.println("Facility Name::"+eachAppointment.getClinic().getFacility().getName());
			System.out.println("Facility Id::"+eachAppointment.getClinic().getFacility().getId());
			System.out.println("Facility Name::"+eachAppointment.getFacility().getName());
			System.out.println("Facility Id::"+eachAppointment.getFacility().getId());*/
			//System.out.println("Provider Name::"+eachAppointment.getProvider().getName());
			//System.out.println("Provider Id::"+eachAppointment.getProvider().getId());
		}				
	}			
}

