package gov.va.med.scheduling.service;

import gov.va.med.scheduling.dto.Email;
import gov.va.med.scheduling.mail.MailSender;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class NotificationService {	
	/**
	 * 
	 */
	private static final String TEXT_FOR_SMS = "user:vosdemo"+"\n"
											 + "password:vosdemo123"+"\n"
											 + "api_id:3425494"+"\n" 
											 + "to:@phone@"+"\n"
											 + "from:12028038288"+"\n"
											 + "mo:1"+"\n"
											 + "text:@text@";
	/**
	 *
	 */
	public NotificationService(){

	}
	/**
	 *
	 */
	public void sendEmail(
		String emailAddress
	, 	String subject
	, 	String text
	){		
		Email mailItem = new Email();
		mailItem.addTo(emailAddress);
		mailItem.setSubject(subject);
		mailItem.setText(text);
		MailSender mailsender = new MailSender();
		mailsender.sendMail(mailItem);
	}
	/**
	 *
	 */
	public void sendSMS(String cellNumber, String text){		
		Map<String,String> inputParam = new HashMap<String,String>();
		inputParam.put("phone", cellNumber);
		inputParam.put("text", text);
		Email mailItem = new Email();
		mailItem.addTo("sms@messaging.clickatell.com");		
		mailItem.setText(getFormattedText(TEXT_FOR_SMS,inputParam));
		mailItem.setSubject("Subject");		
		MailSender mailsender = new MailSender();
		mailsender.sendMail(mailItem);
	}	
	/**
	 * 
	 * @param args
	 */
	public static void main(String args[]){
		NotificationService service = new NotificationService();				
		service.sendSMS("12345678901","Hi, How are you");
		service.sendEmail("aagarwal@ventera.com","Hi", "How are you");
	}
	/**
	 *
	 * @param inputParams
	 * @return
	 */
   private String getFormattedText(
		String notificationText
	, 	Map<String,String> inputParams
	){
		Set<String> keySet = inputParams.keySet();
		for(String key:keySet){			
			notificationText = notificationText.replaceAll("@"+key+"@", inputParams.get(key));
		}
		return notificationText;
	}    
}
