package gov.va.med.scheduling.service;

import gov.va.med.scheduling.dto.User;
import gov.va.med.scheduling.infra.GlobalFunctions;
import gov.va.med.scheduling.infra.XMLDataRepository;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class MVIStubService {	
	/**
	 * 
	 */
	private static MVIStubService INSTANCE = new MVIStubService();	
	/**
	 *
	 */
	private static XMLDataRepository dataRepository = XMLDataRepository.getInstance();
	/**
	 *
	 */
	public MVIStubService() {
	}
	/**
	 * 
	 * @return
	 */
	public static MVIStubService getInstance(){
		return INSTANCE;
	}
	/**
	 * 
	 * @param idPatient
	 * @return
	 */
	public String getMviId(String idUser){			
		return dataRepository.getUserDetails(idUser).getMviId();		
	}	
	/**
	 * 
	 * @param idUser
	 * @return
	 */
	public String getCalendarId(String idUser){
		return dataRepository.getUserDetails(idUser).getCalendarId();
	}
	
	/**
	 * @return the vista2Id
	 */
	public String getVistaId(String idUser, String idFacility) {
		User user = dataRepository.getUserDetails(idUser);
		if(!GlobalFunctions.isNullOrEmpty(idFacility)){
			if("401MC".equals(idFacility)){
				return user.getVista401Id();
			}
			else if("501MC".equals(idFacility)){
				return user.getVista501Id();
			}
			else if("601MC".equals(idFacility)){
				return user.getVista601Id();
			}
		}
		return null;
	}
	/**
	 * @return the vista2Id
	 */
	public User getUser(String idUser) {
		return dataRepository.getUserDetails(idUser);
	}
}

