package gov.va.med.scheduling.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Response;
import gov.va.med.scheduling.dto.User;
import gov.va.med.scheduling.dto.VisitType;
import gov.va.med.scheduling.infra.GlobalConstants;
import gov.va.med.scheduling.infra.GlobalFunctions;
import gov.va.med.scheduling.infra.VAProperties;
import gov.va.med.scheduling.xml.ClinicXmlProcessor;
import gov.va.med.vos.common.AuthSettings;
import gov.va.med.vos.common.CalDAVManager;
import gov.va.med.vos.common.Command;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class ClinicService {	
	
	/**
	 *
	 */
	public ClinicService(){
	}
	
	
	/**
	 * 
	 * @param idPatient
	 * @return
	 */
	public Response getFacilities(User user){						
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(GlobalFunctions.getAllFacilities());
		response.setResponseList(responseList);
		return response;
	}
	
	public Response getAppointmentsByClinic(User user, Facility facility, Clinic clinic){
		List<Appointment> appointmentList = getAppointmentsForClinic(user,facility,clinic);//new ArrayList<Appointment>();					
		System.out.println("ERROR>>>>>>>>68" + clinic.getId() + "\t" + appointmentList.toString());
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(appointmentList);
		response.setResponseList(responseList);
		return response;
	}	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<Appointment> getAppointmentsForClinic(User user, Facility facility, Clinic clinic){		
		try{
			System.out.println("Get appointment for Clinic::"+clinic.getId());
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();	
			Map<String, String> params = new HashMap<String, String>();
			
			Date startDate = GlobalFunctions.getTodayWithoutTime();
			Date endDate = GlobalFunctions.addDaysToDate(startDate, 365);
							
			params.put("STARTDATETIME", GlobalFunctions.formatDateForICalendar(startDate));
			params.put("ENDDATETIME", GlobalFunctions.formatDateForICalendar(endDate));
			
			String requestXml = GlobalFunctions.getFormattedText(GlobalConstants.GET_CALENDAR, params);					
			System.out.println("Request::"+requestXml);		
			Command command = new Command(
								"REPORT"
							,	"/calendars/CLI_"+facility.getId()+"_"+clinic.getId()+"/default"
							, 	requestXml
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				return ClinicXmlProcessor.getInstance().processXmlForCalendar(responseXml,clinic);				
			}
					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * 
	 * @return
	 */
	public Response getClinics(User user, Facility facility){			
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();		
		List<Clinic> clinicList = getClinicsFromCalDavServer(facility);
		for(Clinic clinic:clinicList){
			System.out.println("Checking to see if Clinic is Telehealth::"+clinic.getId());
			List<VisitType> visitTypeList = getVisitTypesFromCalDavServer(facility.getId(),clinic.getId());		
			for(VisitType visitType:visitTypeList){
				if(visitType.isTeleHealthSupported()){
					clinic.setTeleHealthSupported(true);
					break;
				}
			}
		}
		responseList.add(clinicList);
		response.setResponseList(responseList);
		return response;
	}	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<Clinic> getClinicsFromCalDavServer(Facility facility){				
		System.out.println("getClinicsFromCalDavServer()"+facility.getId());
		try{			
			CalDAVManager manager = new CalDAVManager(
									VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
								,	new AuthSettings(
										VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
									, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
									)
								, 	null
								);
			Map<String, String> headers = new HashMap<String, String>();		
			headers.put("Depth", "infinity");
			System.out.println("Request" + GlobalConstants.GET_CLINICS_BY_FACILITY);
			Command command = new Command(
								"PROPFIND"
							,	"/vascheduling/principals/resources/"+facility.getId()
							, 	GlobalConstants.GET_CLINICS_BY_FACILITY
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				List<Clinic> clinicList = ClinicXmlProcessor.getInstance().processXmlGetClinicsByFacility(facility,responseXml);
				if(clinicList!=null && clinicList.size()>0){
					return clinicList;
				}	
			}					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return new ArrayList<Clinic>();
	}			
	/**
	 * 
	 * @return
	 */
	public Response getSpokeClinics(User user, Facility facility){					
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();				
		List<Facility> facilityList = GlobalFunctions.getAllFacilities();
		List<Clinic> masterClinicList  = new ArrayList<Clinic>();
		for(Facility eachFacility:facilityList){
			if(!eachFacility.getId().equals(facility.getId())){
				List<Clinic> clinicList = getTeleHealthClinicsFromCalDavServer(user,eachFacility);
				for(Clinic clinic:clinicList){	
					clinic.setTeleHealthSupported(true);
				}
				masterClinicList.addAll(clinicList);
			}
			
		}			
		responseList.add(masterClinicList);
		response.setResponseList(responseList);
		return response;
	}
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<Clinic> getTeleHealthClinicsFromCalDavServer(User user, Facility facility){		
		List<Clinic> clinicMasterList = getClinicsFromCalDavServer(facility);
		List<Clinic> teleHealthClinics = new ArrayList<Clinic>();
		for(Clinic clinic:clinicMasterList){
			System.out.println("Checking to see if Clinic is Telehealth::"+clinic.getId());
			List<VisitType> visitTypeList = getVisitTypesFromCalDavServer(facility.getId(),clinic.getId());		
			for(VisitType visitType:visitTypeList){
				if(visitType.isTeleHealthSupported()){
					teleHealthClinics.add(clinic);
					break;
				}
			}
		}
		return teleHealthClinics;
	}
	/**
	 * 
	 * @return
	 */
	public Response getVisitTypes(Facility facility,Clinic clinic){			
		List<VisitType> visitTypeList = getVisitTypesFromCalDavServer(facility.getId(),clinic.getId());			
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(visitTypeList);
		response.setResponseList(responseList);
		return response;
	}
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<VisitType> getVisitTypesFromCalDavServer(String idFacility, String idClinic){		
		try{			
			CalDAVManager manager = new CalDAVManager(
										VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_URL)
									,	new AuthSettings(
											VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_USERNAME)
										, 	VAProperties.getInstance().getProperty(GlobalConstants.CALDAV_SERVER_PASSWORD)
										)
									, 	null
									);
			Map<String, String> headers = new HashMap<String, String>();		
			headers.put("Depth", "1");
			Command command = new Command(
								"PROPFIND"
							,	"/vascheduling/principals/resources/"+idFacility+"/"+idClinic+"/"+"Visits"
							, 	GlobalConstants.GET_VISIT_TYPES
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");
				System.out.println(responseXml);
				List<VisitType> visitTypeList = ClinicXmlProcessor.getInstance().processXmlForVisitTypes(responseXml);
				if(visitTypeList!=null && visitTypeList.size()>0){
					return visitTypeList;
				}	
			}					
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return new ArrayList<VisitType>();
	}	
	/**
	 * 
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String args[]){				
		ClinicService service = new ClinicService();
		
		Facility facility = new Facility();
		facility.setId("501MC");
		
		Clinic clinic = new Clinic();
		clinic.setId("GAPC1");
		clinic.setTimezone("America/New_York");
		
		Response response = service.getAppointmentsByClinic(null,facility,clinic);
		List<Object> responseList = response.getResponseList();
		List<Appointment> appointmentList =  (List<Appointment>)responseList.get(0);		
		
		for(Appointment appointment:appointmentList){					
			System.out.println("Name::"+appointment.getStartDateTimeClinic());
			//System.out.println("Facility Id::"+visitType.getId());
			//System.out.println("Facility Name::"+visitType.getDescription());
			//System.out.println("Clinic Id::"+eachAppointment.getTimezone());
			//System.out.println("Provider Name::"+eachAppointment.getProvider().getName());
			//System.out.println("Provider Id::"+eachAppointment.getProvider().getId());
		}				
	}
}

