package gov.va.med.scheduling.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.scheduling.dto.Appointment;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Patient;
import gov.va.med.scheduling.dto.Provider;
import gov.va.med.scheduling.dto.Response;
import gov.va.med.scheduling.dto.User;
import gov.va.med.scheduling.dto.VisitType;
import gov.va.med.scheduling.infra.GlobalConstants;
import gov.va.med.scheduling.infra.GlobalFunctions;
import gov.va.med.scheduling.infra.VAProperties;
import gov.va.med.scheduling.xml.AppointmentXmlProcessor;
import gov.va.med.vos.common.AuthSettings;
import gov.va.med.vos.common.CalDAVManager;
import gov.va.med.vos.common.Command;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class AppointmentService {			
	/**
	 *
	 */
	public AppointmentService(){
	}
	/**
	 * 
	 * @return
	 */
	public Response getAvailableSlots(User user, Appointment appointment){			
		List<Appointment> availableAppointments = getAvailableAppointmentsFromCalDavServer(user, appointment);	
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(availableAppointments);
		response.setResponseList(responseList);
		return response;
	}	
	/**
	 * 
	 * @param appointment
	 * @return
	 */
	public Response makeAppointment(Appointment appointment){
		System.out.println("Appointment Object from Flex:"+appointment.getId());
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();		
		makeAppointmentOnCalDavServer(appointment);
		responseList.add(appointment);
		response.setResponseList(responseList);
		return response;
	}
	/**
	 * 
	 * @return
	 */
	public Response getAppointmentCategories(boolean allFlag){					
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(GlobalFunctions.getCategoryList(allFlag));
		response.setResponseList(responseList);
		return response;
	}	
	/**
	 * 
	 * @param idClinic
	 * @return
	 *//*
	public Response getCancellationReasons() {
		List<CancellationReason> reasons = new ArrayList<CancellationReason>();	
				
		CancellationReason reason1 = new CancellationReason();
		reason1.setId("1");
		reason1.setName("Weather");
		reasons.add(reason1);
		
		CancellationReason reason2 = new CancellationReason();
		reason2.setId("2");
		reason2.setName("Travel Difficulty");
		reasons.add(reason2);
		
		CancellationReason reason3 = new CancellationReason();
		reason3.setId("3");
		reason3.setName("Unable To keep Appointment");
		reasons.add(reason3);
		
		CancellationReason reason4 = new CancellationReason();
		reason4.setId("4");
		reason4.setName("Death in Family");
		reasons.add(reason4);
		
		CancellationReason reason5 = new CancellationReason();
		reason5.setId("5");
		reason5.setName("Other");
		reasons.add(reason5);
		
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(reasons);
		response.setResponseList(responseList);
		return response;
	}	*/
	
	/**
	 * 
	 * @param idClinic
	 * @return
	 *//*
	public Response getCancellationBy() {
		List<CancellationBy> listCancellationBy = new ArrayList<CancellationBy>();	
				
		CancellationBy cancellationBy1 = new CancellationBy();
		cancellationBy1.setId("1");
		cancellationBy1.setName("Cancelled by Clinic");
		listCancellationBy.add(cancellationBy1);
		
		CancellationBy cancellationBy2 = new CancellationBy();
		cancellationBy2.setId("2");
		cancellationBy2.setName("Cancelled By Patient");
		listCancellationBy.add(cancellationBy2);
		
		CancellationBy cancellationBy3 = new CancellationBy();
		cancellationBy3.setId("3");
		cancellationBy3.setName("No Show");
		listCancellationBy.add(cancellationBy3);
		
		CancellationBy cancellationBy4 = new CancellationBy();
		cancellationBy4.setId("4");
		cancellationBy4.setName("No Show and Auto Rebook");
		listCancellationBy.add(cancellationBy4);
		
		CancellationBy cancellationBy5 = new CancellationBy();
		cancellationBy5.setId("5");
		cancellationBy5.setName("Cancelled by Clinic and Auto Rebook");
		listCancellationBy.add(cancellationBy5);
		
		CancellationBy cancellationBy6 = new CancellationBy();
		cancellationBy6.setId("6");
		cancellationBy6.setName("Cancelled by Patient and Auto Rebook");
		listCancellationBy.add(cancellationBy6);
		
		CancellationBy cancellationBy7 = new CancellationBy();
		cancellationBy7.setId("7");
		cancellationBy7.setName("No Action Taken");
		listCancellationBy.add(cancellationBy7);
		
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(listCancellationBy);
		response.setResponseList(responseList);
		return response;
	}	
	*/
	/**
	 * 
	 * @param idClinic
	 * @return
	 *//*
	public Response getAppointmentsByClinic(String idClinic) {
		List<Appointment> availableAppointments = new ArrayList<Appointment>();	
		availableAppointments.add(getAppointment1());
		availableAppointments.add(getAppointment2());
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(availableAppointments);
		response.setResponseList(responseList);
		return response;
	}*/
	
	/**
	 * 
	 * @param appointment
	 * @return
	 *//*
	public Response cancelAppointment(Appointment appointment){
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();		
		appointment.setStatus("Cancelled");
		responseList.add(appointment);
		response.setResponseList(responseList);
		return response;
	}
	*//**
	 * 
	 * @param appointment
	 * @return
	 *//*
	public Response rescheduleAppointment(Appointment appointment){
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();		
		appointment.setStatus("Scheduled");
		responseList.add(appointment);
		response.setResponseList(responseList);
		return response;
	}*/	
	/**
	 * 
	 * @return
	 *//*
	private Appointment getAppointment1(){
		Appointment appointment = new Appointment();		
		appointment.setId("1");			
		appointment.setStatus("Requested");
		appointment.setStartDateTime(
			stringToDateTime(
				formatDate(new Date()) + " 10:00 AM"
			)
		);
		appointment.setEndDateTime(
			stringToDateTime(
				formatDate(new Date()) + " 11:00 AM"
			)
		);
		appointment.setProvider(getProvider1());
		appointment.setClinic(getClinic1());
		appointment.setCategory(getAppointmentCategory1());
		appointment.setVisitType(getVisitType1());
		return appointment;
	}
	*//**
	 * 
	 * @return
	 *//*
	private Appointment getAppointment2(){
		Appointment appointment = new Appointment();		
		appointment.setId("2");			
		appointment.setStatus("Requested");
		appointment.setStartDateTime(
			stringToDateTime(
				formatDate(addDaysToCurrentDate(2)) + " 02:00 PM"
			)
		);
		appointment.setEndDateTime(
			stringToDateTime(
				formatDate(addDaysToCurrentDate(2)) + " 03:00 PM"
			)
		);
		appointment.setProvider(getProvider2());
		appointment.setClinic(getClinic2());
		appointment.setCategory(getAppointmentCategory1());
		appointment.setVisitType(getVisitType2());
		return appointment;
	}
	*//**
	 * 
	 * @return
	 *//*
	private Clinic getClinic1(){
		Clinic clinic = new Clinic();
		clinic.setId("1001");
		clinic.setName("Clinic1");
		clinic.setSpecialty("General Medicinie");
		return clinic;
	}	
	*//**
	 * 
	 * @return
	 *//*
	private Clinic getClinic2(){
		Clinic clinic = new Clinic();
		clinic.setId("1002");
		clinic.setName("Clinic2");
		clinic.setSpecialty("Mental Health");
		return clinic;
	}
	*//**
	 * 
	 * @return
	 *//*
	private Provider getProvider1(){
		Provider provider = new Provider();
		provider.setId("1001");
		provider.setFirstName("Provider1 First Name");
		provider.setLastName("Provider1 Last Name");
		return provider;
	}
	*//**
	 * 
	 * @return
	 *//*
	private Provider getProvider2(){
		Provider provider = new Provider();
		provider.setId("1002");
		provider.setFirstName("Provider2 First Name");
		provider.setLastName("Provider2 Last Name");
		return provider;
	}*/	
	/**
	 * 
	 * @return
	 *//*
	public Response getVisitTypes(
		String idAppointmentCategory
	,	String idProvider
	,	String idClinic
	){			
		List<VisitType> reasonList = getVisitTypesFromCalDavServer("501MC","GAPC1");			
		Response response = new Response();
		List<Object> responseList = new ArrayList<Object>();
		responseList.add(reasonList);
		response.setResponseList(responseList);
		return response;
	}	*/
	/**
	 * 
	 * @return
	 *//*
	private VisitType getVisitType1(){
		VisitType reason = new VisitType();
		reason.setId("101");
		reason.setName("Follow-up");			
		reason.setDuration(30);
		return reason;
	}
	*//**
	 * 
	 * @return
	 *//*
	private VisitType getVisitType2(){
		VisitType reason = new VisitType();
		reason.setId("101");
		reason.setName("Initial");			
		reason.setDuration(45);
		return reason;
	}*/
	
	
	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private void makeAppointmentOnCalDavServer(Appointment appointment){		
		try{
			System.out.println("makeAppointmentOnCalDavServer");
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.ESB_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.ESB_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.ESB_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();																		
			String request = GlobalConstants.CALANDER_WRAPPER_START
							  + appointment.getIcsFile()
							  +"\n"
							  + GlobalConstants.CALANDER_WRAPPER_START_END
							  ;
			System.out.println(request);			
			Command command = new Command(
								"PUT"
							,	"/vos-business-service/http/schedule"
							, 	request
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String response = (String)resultMap.get("response");
				System.out.println("Response: " + response);
				appointment.setStatus("CONFIRMED");
			}				
		}
		catch(Exception e){
			e.printStackTrace();
		}		
	}
	
	
	/**
	 * 
	 * @param patientCalendarId
	 * @return
	 */
	private List<Appointment> getAvailableAppointmentsFromCalDavServer(User user,Appointment appointment){		
		try{
			System.out.println("Get getAvailableAppointmentsFromCalDavServer");
			CalDAVManager manager = new CalDAVManager(
					VAProperties.getInstance().getProperty(GlobalConstants.ESB_SERVER_URL)
				,	new AuthSettings(
						VAProperties.getInstance().getProperty(GlobalConstants.ESB_SERVER_USERNAME)
					, 	VAProperties.getInstance().getProperty(GlobalConstants.ESB_SERVER_PASSWORD)
					)
				, 	null
				);
			Map<String, String> headers = new HashMap<String, String>();										
			Map<String, String> params = new HashMap<String, String>();
			String category = GlobalConstants.REGULAR;
			if(appointment.getCategory()!=null){
				category = appointment.getCategory().getName();
			}			 					
			if(GlobalConstants.TELEHEALTH.equalsIgnoreCase(category)){
				System.out.println("appointment.getIdSpokeClinic()::"+appointment.getIdSpokeClinic());
				if(!GlobalFunctions.isNullOrEmpty(appointment.getIdSpokeClinic()) 
						&& ("HOME".equalsIgnoreCase(appointment.getIdSpokeClinic())
						|| "OTHER".equalsIgnoreCase(appointment.getIdSpokeClinic()))
				){
					params.put("LOCATION",appointment.getIdSpokeClinic());
				}
				else{ 
					params.put("LOCATION", GlobalFunctions.getClinicURL(appointment.getIdSpokeFacility(), appointment.getIdSpokeClinic()));
				}
			}
			else{
				params.put("LOCATION", GlobalFunctions.getClinicURL(appointment.getFacility().getId(), appointment.getClinic().getId()));
			}				
			params.put("ATTENDEE1", GlobalFunctions.getProviderURL(appointment.getProvider().getId()));
			params.put("ATTENDEE2", GlobalFunctions.getPatientURL(appointment.getPatient().getId()));
			params.put("CATEGORIES1", category);//TELEHEALTH/REGULAR
			params.put("CATEGORIES2", appointment.getVisitType().getName());//INITIAL/FOLLOW-UP
			
			if(appointment.getReasonText()!=null){
				params.put("SUMMARY", appointment.getReasonText());
			}
			else{
				params.put("SUMMARY", "");
			}			
			String strStartDate = null;			
			Date startDate = null;
			if(appointment.getStartDateTime()==null){								
				startDate = GlobalFunctions.getTodayWithoutTime();
				strStartDate = GlobalFunctions.formatDateForICalendar(startDate);				
			}
			else {
				strStartDate = GlobalFunctions.formatDateForICalendar(appointment.getStartDateTime());
				startDate = appointment.getStartDateTime();
			}			
			Date endDate = GlobalFunctions.addDaysToDate(startDate, 30);
			String strEndDate = GlobalFunctions.formatDateForICalendar(endDate);
			
			params.put("ENDDATETIME", strEndDate);
			params.put("STARTDATETIME", strStartDate);
			
			String requestXml = GlobalFunctions.getFormattedText(GlobalConstants.GET_AVAILABLE_APPOINTMENTS, params);
			
			System.out.println(requestXml);
			
			Command command = new Command(
								"REPORT"
							,	"/vos-business-service/http/appointments"
							, 	requestXml
							, 	headers
							, 	false
							);
			Map<String, Object> resultMap = manager.executeCommand(command);			
			int statusCode = (Integer) resultMap.get("statusCode");
			System.out.println("Response Status " + statusCode);
			Exception e = (Exception) resultMap.get("responseException");
			if (e != null) {
				System.out.println("Exception: " + e.getMessage());
			} else {				
				String responseXml = (String)resultMap.get("response");		
				System.out.println(responseXml);
				return AppointmentXmlProcessor.getInstance().processXmlForCalendar(responseXml,appointment);				
			}				
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String args[]){		
		User user = MVIStubService.getInstance().getUser("user1");			
		String icsFile = "BEGIN:VEVENT\n"
						+ "UID:9263504FD3AD\n"
						+ "SEQUENCE:0\n"
						+ "DTSTAMP:20130402T185300Z\n"
						+ "DTSTART:20130602T160000Z\n"
						+ "DTEND:20130602T170000Z\n"
						+ "TRANSP:OPAQUE\n"
						+ "SUMMARY:Reason for the appointment\n"
						+ "CATEGORIES:TELEHEALTH,FOLLOW-UP\n"
						+ "ORGANIZER;CN=\"admin\":http://172.31.106.7:80/server.php/principals/admin\n"
						+ "ATTENDEE;CN=\"ZZTEST, ONE\";CUTYPE=PATIENT;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/users/patients/990000\n"
						+ "ATTENDEE;CN=\"SMITH, JANE\";CUTYPE=PROVIDER;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/users/providers/990029\n"
						+ "LOCATION;CN=\"Medical Center Primary Care\";CUTYPE=CLINIC;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED:http://172.31.106.7:80/server.php/vascheduling/principals/resources/501MC/GAPC1\n"
						+ "END:VEVENT"
						;
		
		
		Patient patient = new Patient();
		patient.setId("990000");
		
		Facility facility = new Facility();
		facility.setId("501MC");
		
		Clinic clinic = new Clinic();
		clinic.setId("GAMH");
		clinic.setTimezone("America/New_York");
		
		Provider provider = new Provider();
		provider.setId("990134");
		
		VisitType visitType = new VisitType();
		visitType.setName("Follow-up");
		
		Appointment appointment = new Appointment();
		appointment.setPatient(patient);
		appointment.setFacility(facility);
		appointment.setClinic(clinic);
		appointment.setCategory(GlobalFunctions.getCategory(GlobalConstants.REGULAR));
		appointment.setProvider(provider);
		appointment.setVisitType(visitType);
		//appointment.setIcsFile(icsFile);
		appointment.setIdSpokeClinic("GAPC1");
		appointment.setIdSpokeFacility("401MC");
							
		AppointmentService service = new AppointmentService();
		Response response = service.getAvailableSlots(user, appointment);
		//Response response = service.makeAppointment(appointment);
		List<Object> responseList = response.getResponseList();
		List<Appointment> appointmentList = (List<Appointment>)responseList.get(0);	
		for(Appointment eachAppointment:appointmentList){
			//System.out.println("Appointment ID::"+eachAppointment.getId());
			//System.out.println("Appointment ID::"+eachAppointment.getVisitType().getDescription());
			/*System.out.println("Appointment Start::"+eachAppointment.getStartDateTime());
			System.out.println("Appointment Start::"+eachAppointment.getStartDateTimeStr());
			System.out.println("Appointment Ends::"+eachAppointment.getEndDateTime());
			System.out.println("Appointment Ends::"+eachAppointment.getEndDateTimeStr());
			System.out.println("Clinic Name::"+eachAppointment.getClinic().getName());
			System.out.println("Provider Name::"+eachAppointment.getProvider().getName());*/
			
			
			//System.out.println(eachAppointment.getIcsFile());
		}				
	}	
}

