package gov.va.med.scheduling.mail;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import gov.va.med.scheduling.dto.Notification;

/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class NotificationFactory {
	/**
	 *
	 */
	private static NotificationFactory INSTANCE = new NotificationFactory();
	/**
	 *
	 */
	private static Map<String,Notification> notificationMap = new HashMap<String,Notification>();
	/**
	 *
	 */
	private static boolean initialized = false;
	/**
	 *
	 * @param moduleMap
	 */
	public static void setNotificationMap(Map<String, Notification> notificationMap) {
		NotificationFactory.notificationMap = notificationMap;
	}
	/**
	 *
	 */
	private NotificationFactory(){
		super();
	}
	/**
	 *
	 * @param moduleId
	 * @return
	 */
	public Notification getNotification(String idNotification){
		return notificationMap.get(idNotification);
	}
	/**
	 *
	 * @return
	 */
	public Collection<Notification> getNotifications(){
		return new ArrayList<Notification>(notificationMap.values());
	}
	/**
	 *
	 * @return
	 */
	public static NotificationFactory getInstance(){
		if(!initialized){
			initialize();
			initialized = true;
		}
		return INSTANCE;
	}
	/**
	 *
	 */
	private static void initialize (){
		try{
	       final InputStream inputStream = NotificationFactory.class.getResourceAsStream("/config/notifications.xml");
	       final InputSource inputSource = new InputSource(inputStream);
		   final XPathFactory xPathFactory = XPathFactory.newInstance();
		   final XPath xPath = xPathFactory.newXPath();

		   final DocumentBuilderFactory docBuilderFactory
	                               = DocumentBuilderFactory.newInstance();
		   final DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();
		   final Document document = documentBuilder.parse(inputSource);

		   final NodeList notificationList =
		        	(NodeList) xPath.evaluate("notifications/notification",document, XPathConstants.NODESET);
	       for (int i = 0; i < notificationList.getLength(); i++) {
	    	   Notification notification = new Notification();
	    	   final Node node = notificationList.item(i);
	    	   String idnotification = xPath.evaluate("idnotification", node);
	    	   notification.setSubject(xPath.evaluate("subject", node));
	    	   notification.setText(xPath.evaluate("text", node));
	    	   notification.setId(idnotification);
	    	   notificationMap.put(idnotification,notification);
	       }
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	/**
	 *
	 * @param args
	 */
	public static void main(String[] args){
		System.out.println(NotificationFactory.getInstance().getNotification("NEW_PASSWORD").getText());
	}
}
