package gov.va.med.scheduling.mail;


import gov.va.med.scheduling.dto.Email;
import gov.va.med.scheduling.infra.VAProperties;

import java.util.Properties;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Authenticator;
import javax.mail.Transport;
import javax.mail.PasswordAuthentication;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class MailSender {
	/**
	 *
	 */
	private static final String MAIL_USER
			= "MAIL.USER"
	;
	/**
	 *
	 */
	private static final String MAIL_PASSWORD
			= "MAIL.PASSWORD"
	;
	/**
	 *
	 */
	private static final String MAIL_SMTP_HOST
			= "MAIL.SMTP.HOST"
	;
	/**
	 *
	 */
	private static final String MAIL_SMTP_PORT
			= "MAIL.SMTP.PORT"
	;
	/**
	 *
	 */
	private static final String MAIL_FROM_ADDRESS
			= "MAIL.FROM.ADDRESS"
	;
	/**
	 *
	**/
	private static final String MAIL_DEBUG
			=	"MAIL.DEBUG"
	;
	/**
	 *
	**/
	private static final String MAIL_HOST
			=	"mail.smtp.host"
	;
	/**
	 *
	**/
	private static final String MAIL_FROM
			=	"mail.smtp.from"
	;
	/**
	 *
	**/
	private static final String MAIL_AUTH
			=	"mail.smtp.auth"
	;
	/**
	 *
	 */
	private static final String MAIL_NO_FROM_ADDRESS
			= "MAIL.NO.FROM.ADDRESS"
	;
	/**
	 *
	 */
	private static final String MAIL_NO_TO_ADDRESS
			= "MAIL.NO.TO.ADDRESS"
	;	
	/**
	 *
	 */
	private static final String DEFAULT_PORT = "25";
	/**
	 *
	 */
	private String user
		= null
	;
	/**
	 *
	 */
	private String password
		= null
	;
	/**
	 *
	**/
	private Session smtpSession
		= null
	;
	/**
	 *
	**/
	private Transport smtpTransport
		= null
	;
	/**
	 *
	 */
	private String  fromAddress
		= null
	;
	/**
	 *
	**/
	public MailSender(){
		createSession ();
	}
	/**
	 * 
	 * @param value
	 * @return
	 */
	private boolean isNullOrEmpty(String value){
	  	if(value==null || "".equals(value)){
	   		return true;
	   	}
	   	return false;
	}   
	/**
	 *
	 * @return
	 */
	private String getPort(){
		try{
			return VAProperties.getInstance().getProperty (MAIL_SMTP_PORT);
		}
		catch(Exception e){
			return DEFAULT_PORT;
		}
	}
	/**
	**/
	private void createSession ()
	{
		Properties 	smtpProperties		= null;
		boolean		isAuthRequired		= false;
		EmailAuthenticator	authenticator = null ;
		try {
			if (smtpSession != null) {
				return;
			}
			user = VAProperties.getInstance().getProperty (MAIL_USER);
			if (!isNullOrEmpty(user)) {
				password 	   = VAProperties.getInstance().getProperty (MAIL_PASSWORD);
				authenticator  = new EmailAuthenticator (user, password);
				isAuthRequired = true;
			}
			fromAddress	= VAProperties.getInstance().getProperty (MAIL_FROM_ADDRESS);
			smtpProperties	= new Properties ();
			smtpProperties.setProperty (MAIL_HOST, VAProperties.getInstance().getProperty (MAIL_SMTP_HOST));
			smtpProperties.setProperty (MAIL_FROM, fromAddress);
			smtpProperties.setProperty (MAIL_AUTH, String.valueOf (isAuthRequired));
			smtpProperties.setProperty("mail.smtp.port", getPort());
			smtpProperties.setProperty("mail.smtp.starttls.enable", "true");
			smtpSession = Session.getInstance (smtpProperties, authenticator);
			smtpSession.setDebug (getDebugFlag());
			/*smtpTransport = smtpSession.getTransport (MAIL_PROTOCOL);
			smtpTransport.connect (
				smtpSession.getProperty (MAIL_HOST)
			, 	Integer.parseInt(getPort())
			, 	user
			, 	password
			);*/
		} catch (Exception e) {
			e.printStackTrace ();
			closeSession ();
		}
	}
	/**
	 *
	 * @return
	 */
	private boolean getDebugFlag(){
		String debugFlag = VAProperties.getInstance().getProperty (MAIL_DEBUG);
		if("Y".equals(debugFlag)){
			return true;
		}
		return false;
	}
	/**
	**/
	protected void closeSession ()
	{
		try {
			smtpTransport.close ();
		} catch (Exception e) {
			e.printStackTrace ();
		}
		smtpSession 	= null;
		smtpTransport 	= null;

	}
	/**
	**/
	protected void finalize ()
	{
		closeSession ();
	}
	/**
	 *
	 * @param email
	 * @return
	 */
	private boolean validate(Email email) throws Exception{
		boolean result = true;;
		if(isNullOrEmpty(email.getFrom())
				&& isNullOrEmpty(fromAddress)
		){
			throw new Exception(MAIL_NO_FROM_ADDRESS);
		}
		if(email.getToList().size()==0){
			throw new Exception(MAIL_NO_TO_ADDRESS);
		}
		return result;
	}
	/**
	 *
	**/	
	public void sendMail (Email email)
	{
		MimeMessage		mimeMessage		= null;
		MimeBodyPart 	mimeBodyPart 	= null;
		MimeMultipart	mimeMultiPart 	= null;
		try {
			if(validate(email)){
				InternetAddress	fromInternetAdress[] = new InternetAddress [1];
				if(!isNullOrEmpty(email.getFrom())){
					fromInternetAdress[0] = new InternetAddress (email.getFrom());
				}
				else{
					fromInternetAdress[0] = new InternetAddress (fromAddress);;
				}
				mimeMessage 	= new MimeMessage (smtpSession);
				mimeMessage.addFrom (fromInternetAdress);

				for(String toAddress : email.getToList()){
					if(!isNullOrEmpty(toAddress)){
						mimeMessage.addRecipient (
							Message.RecipientType.TO
						, 	new InternetAddress (toAddress)
						);
					}
				}
				for(String ccAddress : email.getCcList()){
					if(!isNullOrEmpty(ccAddress)){
						mimeMessage.addRecipient (
							Message.RecipientType.CC
						, 	new InternetAddress (ccAddress)
						);
					}
				}
				for(String bccAddress : email.getBccList()){
					if(!isNullOrEmpty(bccAddress)){
						mimeMessage.addRecipient (
							Message.RecipientType.BCC
						, 	new InternetAddress (bccAddress)
						);
					}
				}
				mimeMultiPart = new MimeMultipart ();
				mimeBodyPart = new MimeBodyPart ();
				mimeBodyPart.setDisposition (Part.INLINE);
				mimeBodyPart.setText (email.getText());
				mimeMultiPart.addBodyPart (mimeBodyPart);
				mimeMessage.setSubject (email.getSubject());
				mimeMessage.setContent (mimeMultiPart);
				mimeMessage.saveChanges();
				Transport.send (mimeMessage);
			}
		}	
		catch (Exception e) {
			e.printStackTrace ();			
		}
	}
	/**
	**/
	private class EmailAuthenticator extends Authenticator
	{
		/**
		 *
		 */
		private final String id ;
		/**
		 *
		**/
		private final String password;
		/**
		**/
		EmailAuthenticator (
			String	id
		,	String	password
		) {

			this.id	= id;
			this.password = password;

		}
		/**
		 *
		 */
		public PasswordAuthentication getPasswordAuthentication ()
		{
			return new PasswordAuthentication (id, password);

		}
	}
}
