package gov.va.med.scheduling.infra;

import gov.va.med.scheduling.dto.Role;
import gov.va.med.scheduling.dto.User;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class XMLDataRepository {
	/**
	 *
	 */
	private static final Map<String,User> users = new HashMap<String,User>();
	/**
	 *
	 */
	private static final Map<String,Role> roles = new HashMap<String,Role>();
	/**
	 *
	 */
	private static XMLDataRepository INSTANCE = new XMLDataRepository();
	/**
	 *
	 */
	private XMLDataRepository(){
		loadRoles();
		loadUsers();
	}
	/**
	 *
	 */
	private void loadUsers(){
		try{
	        final InputSource inputSource = new InputSource(
	        		XMLDataRepository.class.getResourceAsStream("/config/users.xml"));

		    final XPathFactory xPathFactory = XPathFactory.newInstance();
		    final XPath xPath = xPathFactory.newXPath();

		    final DocumentBuilderFactory docBuilderFactory
	                               = DocumentBuilderFactory.newInstance();
		    final DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();

		    final Document document = documentBuilder.parse(inputSource);

		    final NodeList userList =
		        	(NodeList) xPath.evaluate("users/user", document, XPathConstants.NODESET);
	        for (int i = 0; i < userList.getLength(); i++) {
	        	User user = new User();
	        	final Node node = userList.item(i);
	        	String idUser = xPath.evaluate("iduser", node);
	        	user.setIdUser(idUser);
	        	user.setPassword(xPath.evaluate("password", node));
	        	user.setName(xPath.evaluate("name", node));
	        	user.setEmail(xPath.evaluate("email", node));	        		        	
	        	String idRole  = xPath.evaluate("role", node);	            
	            user.setRole(roles.get(idRole));	            	           
	            user.setMviId(xPath.evaluate("mviid", node));
	            user.setCalendarId(xPath.evaluate("calendarid", node));
	            user.setVista401Id(xPath.evaluate("vista401id", node));
	            user.setVista501Id(xPath.evaluate("vista501id", node));
	            user.setVista601Id(xPath.evaluate("vista601id", node));
	            user.setTimezone(xPath.evaluate("timezone", node));
	            user.setPhone(xPath.evaluate("phone", node));
	            users.put(idUser,user);
	        }
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	/**
	 *
	 */
	private void loadRoles(){
		try{
	       final InputStream inputStream = XMLDataRepository.class.getResourceAsStream("/config/roles.xml");
	       final InputSource inputSource = new InputSource(inputStream);
		   final XPathFactory xPathFactory = XPathFactory.newInstance();
		   final XPath xPath = xPathFactory.newXPath();

		   final DocumentBuilderFactory docBuilderFactory
	                               = DocumentBuilderFactory.newInstance();
		   final DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();
		   final Document document = documentBuilder.parse(inputSource);

		   final NodeList roleList =
		        	(NodeList) xPath.evaluate("roles/role",document, XPathConstants.NODESET);
	       for (int i = 0; i < roleList.getLength(); i++) {
	    	   Role role = new Role();
	    	   final Node node = roleList.item(i);
	    	   String idRole = xPath.evaluate("idrole", node);
	    	   role.setIdRole(idRole);
	    	   String[] permissionsArray = xPath.evaluate("permissions", node).split(",");
	    	   role.setPermissions(Arrays.asList(permissionsArray));
	    	   roles.put(idRole,role);
	       }
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	/**
	 *
	 * @param idUser
	 * @param idPassword
	 */
	public User authenticateUser(String idUser, String idPassword){
		if(idUser==null || idPassword==null){
			return null;
		}
		User user = users.get(idUser);
		if(user==null){
			return null;
		}
		if(!idPassword.equals(user.getPassword())){
			return null;
		}
		return user;
	}
	/**
	 *
	 * @param idUser
	 * @param idOperation
	 * @return
	 */
	public boolean isUserAuthorised(String idUser, String idPermission){
		if(idUser==null || idPermission==null){
			return false;
		}
		User user = users.get(idUser);
		if(user==null){
			return false;
		}
		Role role = user.getRole();		
		List<String> permissionList = role.getPermissions();
		if(permissionList.contains(idPermission)){
			return true;
		}		
		return false;
	}
	/**
	 *
	 * @param idUser
	 * @return
	 */
	public User getUserDetails(String idUser){
		return users.get(idUser);
	}
	/**
	 *
	 * @return
	 */
	public static XMLDataRepository getInstance(){
		return INSTANCE;
	}
}
