package gov.va.med.scheduling.infra;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class VAProperties {
	/**
	 *
	 */
	private static final String PROPERTIES_FILE_PATH = "/config/vascheduling.properties";
	/**
	 *
	 */
	private final Properties properties = new Properties();
	/**
	 *
	 * @author aagarwal
	 *
	 */
	private static class PropertiesHolder
    {
        private static final VAProperties INSTANCE = new VAProperties();
    }
	/**
	 *
	 */
	private VAProperties(){
		InputStream inputStream = null;
    	try{
    		inputStream = VAProperties.class.getResourceAsStream(PROPERTIES_FILE_PATH);
    		properties.load(inputStream);
    	}
    	catch(final Exception currentEx)
        {
             throw new RuntimeException(currentEx);
        }
        finally
        {
           if(inputStream!=null){try{inputStream.close();}catch(Exception e){e.printStackTrace();}}
        }
	}
	/**
	 *
	 * @param key
	 * @return
	 */
    public String getProperty(final String key)
    {
    	String value = properties.getProperty(key);
    	if(value != null) {
    		value = value.trim();
    	}
    	return value;
    }
    /**
     *
     * @param prefix
     * @return
     * @throws Exception
     */
    public Properties getSubset (
    	String 	prefix
    ){
    	Properties	subsetProperties	=	new Properties();
    	String		key					= 	null;
    	Enumeration<Object>	enumeration	=	properties.keys();
    	while (enumeration.hasMoreElements()) {
    		key = (String) enumeration.nextElement();
    		if (! key.startsWith (prefix)) {
    			continue;
    		}
    		subsetProperties.put (key, properties.getProperty (key).trim());
    	}
    	return subsetProperties;
    }
	/**
	 *
	 */
	public static VAProperties getInstance(){
		return PropertiesHolder.INSTANCE;
	}
	/**
	 *
	 * @param key
	 * @return
	 */
	public int getIntProperty(final String key){
		String value = getProperty(key);
		int intValue = 0;
		try{
			intValue = Integer.parseInt(value);
		}
		catch(Exception e){
			intValue = 0;
		}
		return intValue;
	}
}
