package gov.va.med.scheduling.infra;

import gov.va.med.scheduling.dto.Address;
import gov.va.med.scheduling.dto.Clinic;
import gov.va.med.scheduling.dto.Division;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Patient;
import gov.va.med.scheduling.dto.Phone;
import gov.va.med.scheduling.dto.Provider;
import gov.va.med.scheduling.dto.ServiceSection;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class JSONDataRepository {	
	/**
	 *
	 */
	private static JSONDataRepository INSTANCE = new JSONDataRepository();	
	/**
	 * 
	 */
	private Map<String,Clinic> clinicMap = new HashMap<String,Clinic>();
	/**
	 * 
	 */	
	private Map<String,Division> divisionMap = new HashMap<String,Division>();	
	/**
	 * 
	 */	
	private Map<String,Facility> facilityMap = new HashMap<String,Facility>();
	/**
	 * 
	 */	
	private Map<String,Provider> providerMap = new HashMap<String,Provider>();
	/**
	 * 
	 */	
	private Map<String,ServiceSection> serviceSectionMap = new HashMap<String,ServiceSection>();
	/**
	 * 
	 */	
	private Map<String,Patient> patientMap = new HashMap<String,Patient>();		
	/**
	 * 
	 * @return
	 */
	public Map<String,Clinic> getClinics(){
		return clinicMap;
	}	
	/**
	 * 
	 * @return
	 */
	public Map<String,Division> getDivisions(){
		return  divisionMap;
	}
	/**
	 * 
	 * @return
	 */
	public Map<String,Facility> getFacilities(){
		return facilityMap;
	}
	/**
	 * 
	 * @return
	 */
	public Map<String,ServiceSection> getServiceSections(){
		return serviceSectionMap;
	}
	/**
	 * 
	 * @return
	 */
	public Map<String,Patient> getPatients(){
		return patientMap;
		
	}
	/**
	 * 
	 * @return
	 */
	public Map<String,Provider> getProviders(){
		return providerMap;
	}
	/**
	 *
	 */
	public JSONDataRepository(){
		loadServiceSections();
		loadDivisions();
		loadFacilities();
		loadClinics();
		loadProviders();
		loadPatients();
	}	
	/**
	 * 
	 * @param state
	 */
	private void loadPatientsForState(String state){
		try{
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = (JSONObject) 
						parser.parse(new InputStreamReader(this.getClass().getResourceAsStream("/config/data/"+state+"/UniquePatients.json")));						
			JSONArray  patientList = (JSONArray)jsonObject.get("Patients");
			for(int i = 0; i< patientList.size();i++){
				JSONObject eachPatient = (JSONObject)patientList.get(i);				
				Patient patient = new Patient();								
				patient.setFirstName(
					(String)eachPatient.get("First Name")
				);
				patient.setLastName(
					(String)eachPatient.get("Last Name")
				);
				patient.setGender(
					(String)eachPatient.get("Gender")
				);
				patient.setSsn(
					(String)eachPatient.get("SSN")
				);
				/*patient.setVeteran(
					(String)eachPatient.get("Veteran")
				);*/
				patient.setDateOfBirth(
					GlobalFunctions.stringToDate(
						(String)eachPatient.get("Date Of Birth")
					,	"MM/dd/yyyy"
					)
				);
				patientMap.put(patient.getFirstName(), patient);
			}					
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	
	/**
	 * 
	 * @param state
	 */
	private void loadServiceSections(){
		try{
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = (JSONObject) 
						parser.parse(new InputStreamReader(this.getClass().getResourceAsStream("/config/data/ServiceSections.json")));						
			JSONArray  serviceSectionList = (JSONArray)jsonObject.get("Service Sections");
			for(int i = 0; i< serviceSectionList.size();i++){
				JSONObject eachServiceSection = (JSONObject)serviceSectionList.get(i);				
				ServiceSection serviceSection = new ServiceSection();				
				serviceSection.setType(
					(String)eachServiceSection.get("Type")
				);				
				serviceSection.setName(
					(String)eachServiceSection.get("Name")
				);															
				serviceSectionMap.put(serviceSection.getName(), serviceSection);
			}					
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	
	/**
	 * 
	 * @param state
	 */
	private void loadClinicsForState(String state){
		try{
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = (JSONObject) 
						parser.parse(new InputStreamReader(this.getClass().getResourceAsStream("/config/data/"+state+"/Clinics.json")));						
			JSONArray  clinicList = (JSONArray)jsonObject.get("Clinics");
			for(int i = 0; i< clinicList.size();i++){
				JSONObject eachClinic = (JSONObject)clinicList.get(i);
				
				Clinic clinic = new Clinic();
				clinic.setId("clinic"+(i+1));
								
				clinic.setPhone(
					getPhone((String)eachClinic.get("Phone Number"))
				);				
				clinic.setAbbreviation(
					(String)eachClinic.get("Abbreviation")
				);				
				clinic.setName(
					(String)eachClinic.get("Name")
				);											
				clinic.setProvider(
					getProvider((String)eachClinic.get("Provider"))
				);				
				clinic.setStopCode(
					(String)eachClinic.get("Stop Code")
				);
				clinic.setCreditStopCode(
					(String)eachClinic.get("Credit Stop Code")
				);				
				clinic.setService(
					getServiceSection((String)eachClinic.get("Credit Stop Code"))
				);
				clinic.setNonCount(
					(String)eachClinic.get("Non-Count")
				);
				clinic.setDivision(
					getDivision((String)eachClinic.get("Parent Division"))
				);								
				clinic.setFacility(
					getFacility((String)eachClinic.get("Parent Institution"))
				);
				clinic.setAppointmentLength(
					Integer.parseInt((String)eachClinic.get("Appointment Length"))
				);	
				clinicMap.put(state+clinic.getName(), clinic);
			}					
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	/**
	 * 
	 * @param state
	 */
	private void loadDivisionsForState(String state){
		try{
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = (JSONObject) 
						parser.parse(new InputStreamReader(this.getClass().getResourceAsStream("/config/data/"+state+"/Divisions.json")));						
			JSONArray  divisionsList = (JSONArray)jsonObject.get("Divisions");
			for(int i = 0; i< divisionsList.size();i++){
				JSONObject eachDivision = (JSONObject)divisionsList.get(i);
				
				Division division = new Division();
				division.setId("division"+(i+1));
												
				division.setName(
					(String)eachDivision.get("Name")
				);	
				division.setMultiDivision(
					(String)eachDivision.get("MultiDivision")
				);
				division.setFacilityNumber(
					(String)eachDivision.get("Facility Number")
				);
				division.setOutPatientOnly(
					(String)eachDivision.get("Outpatient Only")
				);
				divisionMap.put(division.getName(), division);
			}					
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	
	/**
	 * 
	 * @param state
	 */
	private void loadFacilitiesForState(String state){
		try{
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = (JSONObject) 
						parser.parse(new InputStreamReader(this.getClass().getResourceAsStream("/config/data/"+state+"/Institutions.json")));						
			JSONArray  facilityList = (JSONArray)jsonObject.get("Institutions");
			for(int i = 0; i< facilityList.size();i++){
				JSONObject eachFacility = (JSONObject)facilityList.get(i);
				
				Facility facility = new Facility();
				facility.setId("division"+(i+1));
												
				facility.setName(
					(String)eachFacility.get("Name")
				);
				facility.setStationNumber(
					(String)eachFacility.get("Station Number")
				);	
				facility.setTypeCode(
					(String)eachFacility.get("Type Code")
				);	
				facility.setMultiDivision(
					(String)eachFacility.get("MultiDivision")
				);	
				facility.setFacilityType(
					(String)eachFacility.get("Facility Type")
				);
				facility.setNpi(
					(String)eachFacility.get("NPI")
				);
				facility.setAddress(
					getAddress(eachFacility)
				);
				facilityMap.put(facility.getName(), facility);
			}					
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	
	
	/**
	 * 
	 * @param state
	 */
	private void loadProvidersForState(String state){
		try{
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = (JSONObject) 
						parser.parse(new InputStreamReader(this.getClass().getResourceAsStream("/config/data/"+state+"/UniqueDoctors.json")));						
			JSONArray  providerList = (JSONArray)jsonObject.get("Doctors");
			for(int i = 0; i< providerList.size();i++){
				JSONObject eachProvider = (JSONObject)providerList.get(i);
				
				Provider provider = new Provider();
				provider.setId("division"+(i+1));											
				provider.setName(
					(String)eachProvider.get("Full Name")
				);
				provider.setInitials(
					(String)eachProvider.get("Initials")
				);
				provider.setSsn(
					(String)eachProvider.get("SSN")
				);
				provider.setNpi(
					(String)eachProvider.get("NPI")
				);
				provider.setGender(
					(String)eachProvider.get("Gender")
				);
				provider.setAccessCode(
					(String)eachProvider.get("Access Code")
				);
				provider.setVerifyCode(
					(String)eachProvider.get("Verify Code")
				);
				provider.setSignatureCode(
					(String)eachProvider.get("Signature Code")
				);
				provider.setPersonClass(
					(String)eachProvider.get("Person Class")
				);
				provider.setDivision(getDivision((String)eachProvider.get("Division Name")));
				providerMap.put(provider.getName(), provider);
			}					
        }
        catch(final Exception exception){
        	exception.printStackTrace();
        }
	}
	
	/**
	 * 
	 * @param facility
	 * @return
	 */
	private Address getAddress(JSONObject facility){
		Address address = new Address();
		address.setAddressLine1((String)facility.get("Street"));
		address.setCity((String)facility.get("City"));
		address.setState((String)facility.get("State"));
		address.setZipcode((String)facility.get("Zip Code"));
		return address;
	}
	
	/**
	 *
	 */
	private void loadDivisions(){
		loadDivisionsForState("AL");
		loadDivisionsForState("CA");
		loadDivisionsForState("GA");
	}
	
	/**
	 *
	 */
	private void loadPatients(){
		loadPatientsForState("AL");
		loadPatientsForState("CA");
		loadPatientsForState("GA");
	}
	
	/**
	 *
	 */
	private void loadProviders(){
		loadProvidersForState("AL");
		loadProvidersForState("CA");
		loadProvidersForState("GA");
	}
	
	/**
	 *
	 */
	private void loadFacilities(){
		loadFacilitiesForState("AL");
		loadFacilitiesForState("CA");
		loadFacilitiesForState("GA");
	}
	
	/**
	 *
	 */
	private void loadClinics(){
		loadClinicsForState("AL");
		loadClinicsForState("CA");
		loadClinicsForState("GA");
	}
	/**
	 * 
	 * @param divisionName
	 * @return
	 */
	private Phone getPhone(String phoneNumber){
		Phone phone = new Phone();
		phone.setNumber(phoneNumber);
		phone.setType("L");
		return phone;
	}
	/**
	 * 
	 * @param providerName
	 * @return
	 */
	private Division getDivision(String divisionName){
		return divisionMap.get(divisionName);				
	}
	
	/**
	 * 
	 * @param providerName
	 * @return
	 */
	private Facility getFacility(String facilityName){
		return facilityMap.get(facilityName);
	}
	
	/**
	 * 
	 * @param providerName
	 * @return
	 */
	private Provider getProvider(String providerName){
		Provider provider = new Provider();
		return provider;
	}
	/**
	 * 
	 * @param providerName
	 * @return
	 */
	private ServiceSection getServiceSection(String type){
		ServiceSection provider = new ServiceSection();
		return provider;
	}
	
	/**
	 *
	 * @return
	 */
	public static JSONDataRepository getInstance(){
		return INSTANCE;
	}
	/**
	 * 
	 * @param args
	 */	
	public static void main(String args[]){		
		JSONDataRepository.getInstance();		
	}
}
