package gov.va.med.scheduling.infra;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.auth.params.AuthPNames;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.params.AuthPolicy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class HTTPExchanger {		
	/**
	 * 
	 */
	private static final String SCHEME = VAProperties.getInstance().getProperty("HTTP.EXCHANGER.SCHEME");
	/**
	 * 
	 */
	private static final String HOSTNAME = VAProperties.getInstance().getProperty("HTTP.EXCHANGER.HOSTNAME");	
	/**
	 * 
	 */
	private static final int PORT = Integer.parseInt(VAProperties.getInstance().getProperty("HTTP.EXCHANGER.PORT"));
	/**
	 * 
	 */
	private static final String HTTP_BASIC_AUTH_USERNAME = VAProperties.getInstance().getProperty("HTTP.EXCHANGER.USERNAME");
	/**
	 * 
	 */
	private static final String HTTP_BASIC_AUTH_PASSWORD = VAProperties.getInstance().getProperty("HTTP.EXCHANGER.PASSWORD");
	/**
	 * 
	 */
	private static final String URI = SCHEME+"://"+HOSTNAME+":"+PORT;
	/**
	 * 
	 */
	private static final String SAMPLE_BROWSER_USER_AGENT = VAProperties.getInstance().getProperty("SAMPLE_BROWSER_USER_AGENT");	
	/**
	 * 
	 */
	private static final DefaultHttpClient httpclient = new DefaultHttpClient();	
	/**
	 * 
	 */
	private static final UsernamePasswordCredentials credentials 
				= new UsernamePasswordCredentials(HTTP_BASIC_AUTH_USERNAME, HTTP_BASIC_AUTH_PASSWORD);		
	/**
	 * 
	 */
	private HTTPExchanger(){		
		httpclient.getParams().setParameter(AuthPNames.TARGET_AUTH_PREF,Arrays.asList(AuthPolicy.DIGEST));
		httpclient.getCredentialsProvider().setCredentials(
			new AuthScope(HOSTNAME,PORT)
		,	credentials
		);
	}
	/**
	 * 
	 * @return
	 */
	public static HTTPExchanger getInstance(){
		return INSTANCE;
	}	
	/**
	 * 
	 * @throws Exception
	 */
	public Map<String,String> exchangeData(String requestBody) {					
		try{
			Map<String,String> resultMap = new HashMap<String,String>();
			HttpHost target = new HttpHost(HOSTNAME, PORT, SCHEME);		
			HttpRequest request = new BasicHttpEntityEnclosingRequest("REPORT", URI);
			((HttpEntityEnclosingRequest) request).setEntity(new StringEntity(requestBody));			
			request.addHeader(BasicScheme.authenticate(credentials, "US-ASCII", false));
			request.addHeader("User-Agent", SAMPLE_BROWSER_USER_AGENT);
			request.addHeader("Cache-Control", "no-cache");
			DetailCapturingResponseHandler responseHandler = new DetailCapturingResponseHandler();
			int statusCode = -1;
			String reponse = null;
			try {
				if (request != null) {
					reponse = httpclient.execute(target, request, responseHandler);						
					statusCode = responseHandler.responseStatus;
				}
			} catch (HttpResponseException e) {			
				statusCode = e.getStatusCode();
				reponse = e.getMessage();
			}
			resultMap.put("statusCode", statusCode+"");
			resultMap.put("response", reponse);			
			return resultMap;
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {		
		
		/**
		 * 
		 */
		String XML_FIRST_LINE 		= "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
		/**
		 * 
		 */
		String GET_PATIENT_XML 	= 	XML_FIRST_LINE 
								+ "<D:principal-property-search xmlns:D=\"DAV:\">"
	     						+ "<D:property-search>"
	     						+ "<D:prop>"
	     						+ "<D:displayname/>"
	     						+ "</D:prop>"
	     						+ "<D:match>@PARAM1@</D:match>"
	     						+ "</D:property-search>"
	     						+ "<D:prop>"
	     						+ "<C:calendar-home-set xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>"
	     						+ "<D:displayname/>"
	     						+ "</D:prop>"
	     						+ "</D:principal-property-search>"
	     						;
		
		
		Map<String,String> inputParam = new HashMap<String,String>();
		inputParam.put("PARAM1", "Super");
		String body = getFormattedText(GET_PATIENT_XML,inputParam);
		Map<String,String> resultMap = HTTPExchanger.getInstance().exchangeData(body);
		System.out.println("Response Status " + resultMap.get("statusCode"));
		System.out.println(resultMap.get("response"));
	}
	/**
	 *
	 * @param inputParams
	 * @return
	 */
	private static String getFormattedText(
		String notificationText
	, 	Map<String,String> inputParams
	){
		Set<String> keySet = inputParams.keySet();
		for(String key:keySet){
			notificationText = notificationText.replaceAll("@"+key+"@", inputParams.get(key));
		}
		return notificationText;
	}    
	/**
	 * 
	 */
	private static HTTPExchanger INSTANCE = new HTTPExchanger(); 
}
