package gov.va.med.scheduling.infra;

import gov.va.med.scheduling.dto.AppointmentCategory;
import gov.va.med.scheduling.dto.Facility;
import gov.va.med.scheduling.dto.Message;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
public class GlobalFunctions {		
	/**
	 * 
	 */
	private static final SimpleDateFormat SDF_UTC = new SimpleDateFormat(GlobalConstants.DATE_TIME_FORMAT_CALENDAR);	
	
	private static final SimpleDateFormat sdflocal1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
	
	private static final SimpleDateFormat sdflocal2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss 'GMT'Z");
	
	private static final List<Facility> facilityList = new ArrayList<Facility>();
	
	private static final Map<String,AppointmentCategory> categoryMap = new HashMap<String,AppointmentCategory>();
	/**
	 * 
	 */
	static{
		SDF_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
				
		Facility one = new Facility();
		one.setId("601MC");
		one.setName("Alabama VA Medical Center");
		
		Facility two = new Facility();
		two.setId("401MC");
		two.setName("California VA Medical Center");
				
		Facility three = new Facility();
		three.setId("501MC");
		three.setName("Georgia VA Medical Center");
		
		facilityList.add(one);
		facilityList.add(two);
		facilityList.add(three);
		
		AppointmentCategory category1 = new AppointmentCategory();
		category1.setId("101");
		category1.setName("COMPENSATION AND PENSION");
		category1.setDescription("Compensation and Pension");
		category1.setPictureLink("images/appointmentcategory/101.png");
		
		AppointmentCategory category2 = new AppointmentCategory();
		category2.setId("102");
		category2.setName("EMPLOYEE");
		category2.setDescription("Employee");
		category2.setPictureLink("images/appointmentcategory/102.png");
		
		AppointmentCategory category3 = new AppointmentCategory();
		category3.setId("103");
		category3.setName(GlobalConstants.REGULAR);
		category3.setDescription("Office Visit");
		category3.setPictureLink("images/appointmentcategory/103.png");
		
		AppointmentCategory category4 = new AppointmentCategory();
		category4.setId("104");
		category4.setName(GlobalConstants.TELEHEALTH);
		category4.setDescription("Telehealth");
		category4.setPictureLink("images/appointmentcategory/104.png");
		
		AppointmentCategory category5 = new AppointmentCategory();
		category5.setId("105");
		category5.setName(GlobalConstants.HOLIDAY);
		category5.setDescription("Holiday");
		category5.setPictureLink("images/appointmentcategory/105.png");
		
		AppointmentCategory category6 = new AppointmentCategory();
		category6.setId("106");
		category6.setName(GlobalConstants.UNAVIALABLE);
		category6.setDescription("Unavialable");
		category6.setPictureLink("images/appointmentcategory/106.png");
		
		categoryMap.put(category1.getName(), category1);
		categoryMap.put(category2.getName(), category2);
		categoryMap.put(category3.getName(), category3);
		categoryMap.put(category4.getName(), category4);
		categoryMap.put(category5.getName(), category5);
		categoryMap.put(category6.getName(), category6);
	}	
	
	/**
	 * 
	 * @return
	 */
	public static List<AppointmentCategory> getCategoryList(boolean allFlag){
		List<AppointmentCategory> categoryList = new ArrayList<AppointmentCategory>();	
		if(allFlag){
			categoryList.addAll(categoryMap.values());
		}
		else{
			categoryList.add(categoryMap.get(GlobalConstants.REGULAR));
			categoryList.add(categoryMap.get(GlobalConstants.TELEHEALTH));
		}
		return categoryList;
	}	
	/**
	 * 
	 * @param categoryName
	 * @return
	 */
	public static AppointmentCategory getCategory(String categoryName){
		return categoryMap.get(categoryName);
	}
	
	/**
	 * 
	 * @param idFacility
	 * @return
	 */
	public static Facility getFacility(String idFacility){
		for(Facility facility:facilityList){
			if(facility.getId().equals(idFacility)){
				return facility;
			}
		}
		return null;
	}
	/**
	 *
	 */
	private GlobalFunctions(){
		throw new AssertionError("GlobalFunctions Class cannot be instatiated.");
	}
	
	/**
	 * 
	 * @return
	 */
	public static List<Facility> getAllFacilities(){		
		return facilityList;
	}
	
	/**
	 * 
	 * @param idFacility
	 */
	public static String getClinicTimeZone(String idFacility){		
		if(idFacility.equals("401MC")){
			return "America/Los_Angeles";
		}
		else if(idFacility.equals("501MC")){
			return "America/New_York";
		}
		else if(idFacility.equals("601MC")){
			return "America/Chicago";
		}
		return null;
	}
	
	/**
	 *
	 * @param key
	 * @return
	 */
   public static Message getI18NMessage(final String key)
   {
	   Message message = new Message();
	   message.setId(key);
	   message.setMessage(getI18NMessageAsString(key,null));
	   return message;
   }
   /**
    *
    * @param key
    * @param params
    * @return
    */
   public static Message getI18NMessage(final String key, String[] params)
   {
	   Message message = new Message();
	   message.setId(key);
	   message.setMessage(getI18NMessageAsString(key,params));
	   return message;
   }
	/**
	 *
	 * @param key
	 * @return
	 */
    public static String getI18NMessageAsString(final String key)
    {
    	return getI18NMessageAsString(key,null);
    }
    /**
	 *
	 * @param key
	 * @return
	 */
    public static String getI18NMessageAsString(final String key, String[] params)
    {
        boolean         valueFound = true;
        String          result = GlobalConstants.EMPTY_STRING;
        final String    currentKey = trimString(key);
        final String    bundleName = VAProperties.getInstance().getProperty(GlobalConstants.RESOURCE_BUNDLE_ID);
        if ((bundleName == null) || (currentKey.length() == 0))
        {
            result = currentKey;
        }
        else
        {
            try{
            	result = ResourceBundle.getBundle(bundleName).getString(currentKey);               
            }
            catch (final Exception currentEx)
            {
                valueFound = false;
            }
            if (!valueFound)
            {
                result = currentKey;
            }
        }
        return getFormattedMessage(result, params);
    }
    /**
	 * @param message String
	 * @param params String
	 * @return String
	 */
	public static String getFormattedMessage(
		final String message
	,	final String[] params
	) {
		final MessageFormat messageFormat = new MessageFormat(message);
		messageFormat.format(params);
		return messageFormat.format(params);
	}
    /**
     *
     * @param value
     */
    public static boolean isNullOrEmpty(String value){
    	if(value==null || "".equals(value)){
    		return true;
    	}
    	return false;
    }   
	/**
	 *
	 * @param p_date
	 * @param p_dateFormatter
	 * @return
	 */
	public static String formatDate (
		java.util.Date	date
	) {
		SimpleDateFormat dateFormatter = new SimpleDateFormat(getI18NMessageAsString(GlobalConstants.DATE_FORMAT));
		if (date == null) {
			return null;
		}
		return dateFormatter.format (date);
	}
	/**
	 *
	 * @param p_date
	 * @param p_dateFormatter
	 * @return
	 */
	public static String formatDateWithTime (
		java.util.Date	date
	) {
		SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
		if (date == null) {
			return null;
		}
		return dateFormatter.format (date);
	}
	/**
	 *
	 * @param strDate
	 * @return
	 */
	public static java.util.Date stringToDate(
		String	strDate
	){
		if(isNullOrEmpty(strDate))return null;
		try{
			SimpleDateFormat dateFormatter = new SimpleDateFormat(getI18NMessageAsString(GlobalConstants.DATE_FORMAT));
			return dateFormatter.parse (strDate);
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 *
	 * @param strDate
	 * @return
	 */
	public static java.util.Date stringToDate(
		String	strDate
	,	String  format
	){		
		if(isNullOrEmpty(strDate))return null;
		try{
			SimpleDateFormat dateFormatter = new SimpleDateFormat(format);
			return dateFormatter.parse (strDate);
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 *
	 * @param strDate
	 * @return
	 */
	public static java.util.Date stringToDateTime(
		String	strDate
	){
		if(isNullOrEmpty(strDate))return null;
		try{
			SimpleDateFormat dateFormatter = new SimpleDateFormat(getI18NMessageAsString(GlobalConstants.DATE_TIME_FORMAT));
			return dateFormatter.parse (strDate);
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 *
	 * @param number
	 * @return
	 */
	public static Date addDaysToCurrentDate(int number){
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, number);
		return cal.getTime();
	}
	/**
	 *
	 * @param number
	 * @return
	 */
	public static Date addDaysToDate(Date date, int number){
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DATE, number);
		return cal.getTime();
	}		
	/**
	 *
	 * @return
	 */
	public static Date getInfiniteDate(){
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.DAY_OF_MONTH, 31);
		calendar.set(Calendar.MONTH, Calendar.DECEMBER);
		calendar.set(Calendar.YEAR, 2999);
		return stringToDate(formatDate(calendar.getTime()));
	}	
	/**
	 *
	 * @param strDate
	 * @return
	 */
	public static java.util.Date getTodayWithoutTime(){		
		Calendar cal = Calendar.getInstance();
	    cal.set(Calendar.HOUR_OF_DAY, 0);
	    cal.set(Calendar.MINUTE, 0);
	    cal.set(Calendar.SECOND, 0);
	    cal.set(Calendar.MILLISECOND, 0);
	    return cal.getTime();
	}
	
	/**
     */
    public static String trimString( final String inputString )
    {
        String result = inputString ;

        if( result == null )
        {
            result = GlobalConstants.EMPTY_STRING ;
        }
        return result.trim() ;
    }
    /**
	 *
	 * @param inputParams
	 * @return
	 */
    public static String getFormattedText(
		String notificationText
	, 	Map<String,String> inputParams
	){
		Set<String> keySet = inputParams.keySet();
		for(String key:keySet){			
			notificationText = notificationText.replaceAll("@"+key+"@", inputParams.get(key));
		}
		return notificationText;
	}    
    /**
     * 
     * @param filePath
     * @param clazz
     * @return
     */
    public static String readFileAsString(String filePath, Class<?> clazz) {
    	StringBuilder contents = new StringBuilder();
    	BufferedReader reader = null;
    	try {    	          		
    		reader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(filePath)));    		
    		String line = null;
    	    while (( line = reader.readLine()) != null){
    	       	contents.append(line);
    	        contents.append(System.getProperty("line.separator"));
    	    }    		
    	}
    	catch (Exception ex){
    		ex.printStackTrace();
    	}        
    	finally {
    		try{reader.close();}catch(Exception e){};
    	}
    	return contents.toString();    
    }  
    /**
	 * 
	 * @param value
	 * @return
	 */
    public static String removeQuotes(String value){
		if(!GlobalFunctions.isNullOrEmpty(value)){
			if(value.charAt(0)=='"'){
				value = value.substring(1,value.length()-1);
			}
		}
		return value;
	}
    /**
	 * 
	 * @param idPatient
	 * @return
	 */
    public static String getPatientURL(String idPatient){
		return 	"http://"
			+	VAProperties.getInstance().getProperty("CALDAV.SERVER.IP")
			+	":80/server.php/vascheduling/principals/"
			+	"users/patients/"
			+	idPatient
			;
	}
    /**
	 * 
	 * @param idPatient
	 * @return
	 */
    public static String getProviderURL(String idProvider){
		return 	"http://"
			+	VAProperties.getInstance().getProperty("CALDAV.SERVER.IP")
			+	":80/server.php/vascheduling/principals/"
			+	"users/providers/"
			+	idProvider
			;
	}
    /**
	 * 
	 * @param idPatient
	 * @return
	 */
    public static String getClinicURL(String idFacility, String idClinic){
		return 	"http://"
			+	VAProperties.getInstance().getProperty("CALDAV.SERVER.IP")
			+	":80/server.php/vascheduling/principals/"
			+	"resources/"
			+	idFacility+"/"+idClinic
			;
	}
    
    /**
	 *
	 * @param p_date
	 * @param p_dateFormatter
	 * @return
	 */
	public static String formatDateForICalendar (
		java.util.Date date
	) {				
		SimpleDateFormat sdfCalendar = new SimpleDateFormat(GlobalConstants.DATE_TIME_FORMAT_CALENDAR);
		System.out.println("Converting local time for Calendar Server...");
		System.out.println("Date in Local::"+date);
		if (date == null) {
			return null;
		}
		String dateInUtc = sdfCalendar.format(date)+"Z";
		System.out.println("Date for Calendar Server:"+dateInUtc);
		return dateInUtc;
	}    
	/**
	 * 
	 * @param dateInUtc
	 * @return
	 */
	public static String convertAsPerTimezone(Date dateInUtc, String timeZone){																		
		//System.out.println("Converting UTC into timeZone.....::"+timeZone);
		//System.out.println("Date in UTC:"+dateInUtc);
		try{						
			sdflocal1.setTimeZone(TimeZone.getTimeZone(timeZone));							
			String dateInLocal = sdflocal1.format(dateInUtc);
			//System.out.println("Date in Local::"+dateInLocal);
			return dateInLocal;
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @param dateInUtc
	 * @return
	 */
	public static String convertAsPerTimezoneClinic(Date dateInUtc, String timeZone){																		
		//System.out.println("Converting UTC into timeZone.....::"+timeZone);
		//System.out.println("Date in UTC:"+dateInUtc);
		try{						
			sdflocal2.setTimeZone(TimeZone.getTimeZone(timeZone));							
			String dateInLocal = sdflocal2.format(dateInUtc);
			//System.out.println("Date in Local::"+dateInLocal);
			return dateInLocal;
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 
	 * @param timezoneFromCalDav
	 * @return
	 */
	public static String getConvertedTimeZone(String timezoneFromCalDav){
		if(timezoneFromCalDav.equals("America/Los Angeles")){
			return "America/Los_Angeles";
		}
		else if(timezoneFromCalDav.equals("America/New York")){
			return "America/New_York";
		}
		else if(timezoneFromCalDav.equals("America/Chicago")){
			return "America/Chicago";
		}
		return timezoneFromCalDav;
	}
}
