package gov.va.med.scheduling.dto;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
/**
 * Copyright 2013 [OSHERA]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 * @author aagarwal
 *
 */
@ExternalizedBean(type=DefaultExternalizer.class)
public class Patient {
	/**
	 * 
	 */
	private String id;		
	/**
	 * 
	 */
	private String calendarReference;	
	/**
	 * 
	 */
	private String name;
	/**
	 *
	 */
	private String firstName;
	/**
	 * 
	 */
	private String middleName;
	/**
	 * 
	 */
	private String lastName;
	/**
	 * 
	 */
	private String gender;
	/**
	 * 
	 */
	private boolean veteran;
	/**
	 * 
	 */
	private Date dateOfBirth;
	/**
	 * 
	 */
	private Address address;	
	/**
	 * 
	 */
	private String ssn;
	/**
	 * 
	 */
	private List<Phone> phoneList;
	/**
	 * 
	 */
	private InsuranceInfo insuranceInfo;
	/**
	 * 
	 */
	private Contact emergencyContact;	
	/**
	 * 
	 */
	private PatientPreferences preferences;		
	/**
	 * 
	 */
	private String ien;
	/**
	 * 
	 */
	private String idCalendarServer;
	/**
	 * 
	 */
	private Facility facility;
	/**
	 * @return the facility
	 */
	public Facility getFacility() {
		return facility;
	}
	/**
	 * @param facility the facility to set
	 */
	public void setFacility(Facility facility) {
		this.facility = facility;
	}
	/**
	 * 
	 */
	private Map<String,String> vistaIdMap = new HashMap<String,String>();	
	/**
	 * @return the calendarReference
	 */
	public String getCalendarReference() {
		return calendarReference;
	}
	/**
	 * @param calendarReference the calendarReference to set
	 */
	public void setCalendarReference(String calendarReference) {
		this.calendarReference = calendarReference;
	}
	/**
	 * @return the ien
	 */
	public String getIen() {
		return ien;
	}
	/**
	 * @param ien the ien to set
	 */
	public void setIen(String ien) {
		this.ien = ien;
	}
	/**
	 * @return the idCalendarServer
	 */
	public String getIdCalendarServer() {
		return idCalendarServer;
	}
	/**
	 * @param idCalendarServer the idCalendarServer to set
	 */
	public void setIdCalendarServer(String idCalendarServer) {
		this.idCalendarServer = idCalendarServer;
	}
	/**
	 * @return the vistaIdMap
	 */
	public Map<String, String> getVistaIdMap() {
		return vistaIdMap;
	}
	/**
	 * @param vistaIdMap the vistaIdMap to set
	 */
	public void setVistaIdMap(Map<String, String> vistaIdMap) {
		this.vistaIdMap = vistaIdMap;
	}
	/**
	 * @return the gender
	 */
	public String getGender() {
		return gender;
	}
	/**
	 * @param gender the gender to set
	 */
	public void setGender(String gender) {
		this.gender = gender;
	}
	/**
	 * @return the veteran
	 */
	public boolean isVeteran() {
		return veteran;
	}
	/**
	 * @param veteran the veteran to set
	 */
	public void setVeteran(boolean veteran) {
		this.veteran = veteran;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the preferences
	 */
	public PatientPreferences getPreferences() {
		return preferences;
	}
	/**
	 * @param preferences the preferences to set
	 */
	public void setPreferences(PatientPreferences preferences) {
		this.preferences = preferences;
	}
	/**
	 * @return the emergencyContact
	 */
	public Contact getEmergencyContact() {
		return emergencyContact;
	}
	/**
	 * @param emergencyContact the emergencyContact to set
	 */
	public void setEmergencyContact(Contact emergencyContact) {
		this.emergencyContact = emergencyContact;
	}
	/**
	 * @return the phoneList
	 */
	public List<Phone> getPhoneList() {
		return phoneList;
	}
	/**
	 * @param phoneList the phoneList to set
	 */
	public void setPhoneList(List<Phone> phoneList) {
		this.phoneList = phoneList;
	}
	/**
	 * @return the ssn
	 */
	public String getSsn() {
		return ssn;
	}
	/**
	 * @param ssn the ssn to set
	 */
	public void setSsn(String ssn) {
		this.ssn = ssn;
	}	
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}	
	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}
	/**
	 * @param firstName the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	/**
	 * @return the middleName
	 */
	public String getMiddleName() {
		return middleName;
	}
	/**
	 * @param middleName the middleName to set
	 */
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}
	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return lastName;
	}
	/**
	 * @param lastName the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	/**
	 * @return the dateOfBirth
	 */
	public Date getDateOfBirth() {
		return dateOfBirth;
	}
	/**
	 * @param dateOfBirth the dateOfBirth to set
	 */
	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}
	/**
	 * @return the address
	 */
	public Address getAddress() {
		return address;
	}
	/**
	 * @param address the address to set
	 */
	public void setAddress(Address address) {
		this.address = address;
	}
	/**
	 * @return the insuranceInfo
	 */
	public InsuranceInfo getInsuranceInfo() {
		return insuranceInfo;
	}
	/**
	 * @param insuranceInfo the insuranceInfo to set
	 */
	public void setInsuranceInfo(InsuranceInfo insuranceInfo) {
		this.insuranceInfo = insuranceInfo;
	}	
	/**
	 * 
	 */
	public boolean equals(Object that){
		try{
			if(that==null || !(that instanceof Patient)) return false;
			Patient patient = (Patient)that;
			if(this.getName().equals(patient.getName())){
				return true;
			}
		}catch(Exception e){			
		}
		return false;
	}
	/**
	 * 
	 * @return
	 */
	public int hashcode(){
		try{
			return this.getFirstName().hashCode();
		}
		catch(Exception e){
			
		}
		return 0;
	}
}
